package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 05.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Негативные сценарии обновления кампаний со стратегиями, которые не сочетаются друг с другом")
@Tag(TagDictionary.TRUNK)
public class StrategyCombinationsNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45809
                //отключено на поиске и на сети
                {"ServingOff + ServingOff",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultServingOff()},
                //отключено на поиске и NetworkDefault на сети
                //DIRECT-45810
                {"ServingOff + NetworkDefault",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault()},
                //ручная стратегия на поиске и автоматическая на сети
                {"HighestPosition + AverageCpc",
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpc(currency)},
                //DIRECT-45806
                {"HighestPosition + MaximumConversionRate",
                        new TextCampaignSearchStrategyMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(currency, 0L)},
                //автоматическая стратегия на поиске и автоматическая на сети
                {"MaximumClicks + AverageCpa",
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpa(currency, 0L)},
                //автоматическая стратегия на поиске и MaximumCoverage на сети
                //DIRECT-45814
                {"MaximumClicks + MaximumCoverage",
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency),
                        new TextCampaignNetworkStrategyMap().defaultMaximumCoverage()}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 100L, 100L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1126")
    public void strategyCombinationNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy)))),
                ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.STRATEGIES_NOT_COMPATIBLE)));
    }
}
