package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.CoreMatchers.nullValue;

/**
 * Created by chicos on 07.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка ошибок при обновлении текстовой кампании стратегиями требующими GoalId")
@Tag(TagDictionary.TRUNK)
public class StrategyMetrikaGoalIdUpdateNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long[] goalIds = MetrikaGoals.getConterGoalIds(counterId, 2);
    private static TextCampaignStrategyMap strategyMap;
    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String placeName;

    @Parameterized.Parameter(value = 2)
    public String strategyName;

    @Parameterized.Parameter(value = 3)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 4)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 5)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}, place = {1}, strategy = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Все цели", "Network", "AverageCpa",
                        new TextCampaignNetworkStrategyMap().defaultAverageCpa(currency, 0L),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED))},
                {"Все цели", "Network", "MaximumConversionRate",
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(currency, 0L),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED))},
                {"Все цели", "Network", "AverageRoi",
                        new TextCampaignNetworkStrategyMap().defaultAverageRoi(0L),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED))},
                {"Все цели", "Search", "AverageCpa",
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(currency, 0L),
                        ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Collections.singletonList(new Notification(4000,
                                        Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED)))},
                {"Все цели", "Search", "MaximumConversionRate",
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(currency, 0L),
                        ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Collections.singletonList(new Notification(4000,
                                        Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED)))},
                {"Все цели", "Search", "AverageRoi",
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        new TextCampaignSearchStrategyMap().defaultAverageRoi(0L),
                        ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Collections.singletonList(new Notification(4000,
                                        Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED)))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalIds[0], 10L, 100L);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalIds[1], 100L, 100L);

        strategyMap = new TextCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);
    }

    @Test
    public void strategyWithGoalIdUpdateNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(strategyMap))),
                expectedResult);
    }
}
