package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 06.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
//Так как основной объем проверок стратегий проходит для Search, в данном тесте проверяем сохранение всех полей стратегий Network
@Description("Позитивные сценарии обновления текстовой кампании со всеми установленными полями для стратегий Network")
@Tag(TagDictionary.TRUNK)
public class StrategyNetworkAllFieldsUpdateTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private static TextCampaignStrategyMap strategyMap;
    private Long campaignId;


    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45818
                {"AverageCpc",
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPC)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                .withAverageCpc(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        new TextCampaignSearchStrategyMap().defaultServingOff()},
                {"MaximumClicks",
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .withBidCeiling(moneyCurrency.getMinPrice().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        new TextCampaignSearchStrategyMap().defaultServingOff()},
                {"AverageCpa",
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA)
                                .withAverageCpa(new StrategyAverageCpaMap()
                                .withAverageCpa(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                .withBidCeiling(moneyCurrency.getMinAveragePrice().getNext().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())
                                .withGoalId(goalId)),
                        new TextCampaignSearchStrategyMap().defaultServingOff()},
                {"MaximumConversionRate",
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                                .withBidCeiling(moneyCurrency.getMinAveragePrice().getNext().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())
                                .withGoalId(goalId)),
                        new TextCampaignSearchStrategyMap().defaultServingOff()},
                {"AverageRoi",
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .withBidCeiling(moneyCurrency.getMinAveragePrice().getNext().bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())
                                .withGoalId(goalId)
                                .withProfitability(StrategyAverageRoiMap.DEFAULT_PROFITABILITY)
                                .withRoiCoef(StrategyAverageRoiMap.DEFAULT_ROI_COEF)
                                .withReserveReturn(StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN)),
                        new TextCampaignSearchStrategyMap().defaultServingOff()},
                {"NetworkDefault",
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(currency)}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 100L, 100L);

        strategyMap = new TextCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1129")
    public void strategyNetworkTest() {
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(strategyMap)));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());
        assumeThat("получили стратегию Network кампании", actualStrategy.getNetwork(), notNullValue());

        assertThat("получили корректную стратегию Network", actualStrategy.getNetwork(),
                beanDifferV5((TextCampaignNetworkStrategy) networkStrategy.withNetworkDefault(null).getBean()));
    }
}
