package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-69356
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-64814")
@Description("Использование ecommerce цели в параметрах стратегии при обновлении кампании")
public class StrategyWithEcommerceGoalIdTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;
    static Long ecommerceGoalId = 3088178171L;  // counter = 88178171 для at-campaigns-client

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 3)
    public TextCampaignSearchStrategyMap expectedSearchStrategy;

    @Parameterized.Parameter(value = 4)
    public TextCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameters(name = "{0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Search:WbMaximumConversionRate with ecommerce",
                        new TextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(currency, ecommerceGoalId),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(currency, ecommerceGoalId),
                        new TextCampaignNetworkStrategyMap().defaultServingOff()},
                {"Search:AverageCpa with ecommerce",
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(currency, ecommerceGoalId),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault(),
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(currency, ecommerceGoalId),
                        new TextCampaignNetworkStrategyMap().withBiddingStrategyType(
                                TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)},
                {"Search:AverageRoi with ecommerce",
                        new TextCampaignSearchStrategyMap().withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                        .defaultStrategyAverageRoi()
                                        .withWeeklySpendLimit(MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue())
                                        .withProfitability(StrategyAverageRoiMap.DEFAULT_PROFITABILITY)
                                        .withBidCeiling(null)
                                        .withGoalId(ecommerceGoalId)),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap().withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withWeeklySpendLimit(MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue())
                                .withProfitability(StrategyAverageRoiMap.DEFAULT_PROFITABILITY)
                                .withBidCeiling(null)
                                .withGoalId(ecommerceGoalId)),
                        new TextCampaignNetworkStrategyMap().defaultServingOff()},
                {"Network:WbMaximumConversionRate with ecommerce",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(currency, ecommerceGoalId),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(currency, ecommerceGoalId)},
                {"Network:AverageCpa with ecommerce",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpa(currency, ecommerceGoalId),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpa(currency, ecommerceGoalId)},
                {"Network:AverageRoi with ecommerce",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withWeeklySpendLimit(MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue())
                                .withProfitability(StrategyAverageRoiMap.DEFAULT_PROFITABILITY)
                                .withBidCeiling(null)
                                .withGoalId(ecommerceGoalId)),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withWeeklySpendLimit(MoneyCurrency.get(currency).getMinWeeklyBudgetAmount().bidLong().longValue())
                                .withProfitability(StrategyAverageRoiMap.DEFAULT_PROFITABILITY)
                                .withBidCeiling(null)
                                .withGoalId(ecommerceGoalId))},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campMetrikaGoalsSteps()
                .createCampMetrikaGoals(campaignId, ecommerceGoalId, 100L, 100L);
    }

    @Test
    public void strategyWithECommerceGoalIdTest() {
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        TextCampaignStrategyMap expectedStrategy = new TextCampaignStrategyMap()
                .withSearch(expectedSearchStrategy)
                .withNetwork(expectedNetworkStrategy);

        assertThat("получили корректные стратегии", actualStrategy,
                beanDifferV5((TextCampaignStrategy) expectedStrategy.getBean()));
    }
}

