package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpcMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 23.10.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Обновление текстовой кампании со сменой стратегии на поиске без указания всех обязательных полей новой " +
        "стратегии")
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-46885")
public class UpdateSearchToStrategyWithoutRequiredFieldsTest {

    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);
    private static final Long goalId = MetrikaGoals.getGoalsForLogin(client, 1).get(0);
    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyMap searchStrategyUpdate;

    @Parameterized.Parameter(value = 2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "strategy = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-46091
                {"WbMaximumClicks without WeeklySpendLimit",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .withBidCeiling(null)),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.WEEKLY_BUDGET_MUST_NOT_SPECIFIED))},
                {"WbMaximumConversionRate without WeeklySpendLimit",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                                .withBidCeiling(null)
                                .withGoalId(goalId)),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.WEEKLY_BUDGET_MUST_NOT_SPECIFIED))},
                {"WbMaximumConversionRate without GoalId",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                                .withBidCeiling(null)
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.GOAL_NOT_SET))},
                {"AverageCpc without AverageCpc",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                                .withAverageCpc(new StrategyAverageCpcMap()
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(
                                new Notification(4000, Api5ErrorDetails.AVERAGE_CPC_VALUE_NOT_SPECIFIED))},
                {"AverageCpa without AverageCpa",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                                .withAverageCpa(new StrategyAverageCpaMap()
                                .withGoalId(goalId)
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.AVERAGE_CPA_NOT_SPECIFIED))},
                {"AverageCpa without GoalId",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                                .withAverageCpa(
                                new StrategyAverageCpaMap()
                                        .withAverageCpa(moneyCurrency.getMinAveragePrice().bidLong().longValue())
                                        .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.GOAL_NOT_SET))},
                {"AverageRoi without ReserveReturn",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .withRoiCoef(StrategyAverageRoiMap.DEFAULT_ROI_COEF)
                                .withGoalId(goalId)
                                .withBidCeiling(null)),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.RESERVE_RETURN_NOT_SPECIFIED))},
                {"AverageRoi without RoiCoef",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .withReserveReturn(StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN)
                                .withGoalId(goalId)
                                .withBidCeiling(null)),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.ENTER_ROI_COEF_VALUE))},
                {"AverageRoi without GoalId",
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .withRoiCoef(StrategyAverageRoiMap.DEFAULT_ROI_COEF)
                                .withReserveReturn(StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN)
                                .withBidCeiling(null)),
                        ExpectedResult.errors(new Notification(4000, Api5ErrorDetails.GOAL_NOT_SET))},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    @Step("Подготовим данные для теста")
    public static void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff()))));

        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campMetrikaGoalsSteps()
                .addOrUpdateMetrikaGoals(campaignId, goalId, 100L, 100L);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1131")
    public void nameMismatchParamsTest() {
        //DIRECT-47698
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategyUpdate)))),
                expectedResult);
    }
}
