package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy.averageroi;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.StrategyAverageRoi;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import com.yandex.direct.api.v5.campaigns.UpdateResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 04.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка взаимных сочетаний параметров ReserveReturn, RoiCoef, Profitability при обновлении кампании со" +
        " стратегией AverageRoi")
@Tag(TagDictionary.TRUNK)
public class StrategyAverageRoiFieldCombinationsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String client = CampaignsLogins.CLIENT;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private Long campaignId;

    private TextCampaignStrategyMap strategyMap;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public Integer reserveReturn;

    @Parameterized.Parameter(value = 1)
    public Long roiCoef;

    @Parameterized.Parameter(value = 2)
    public Long profitability;

    @Parameterized.Parameters(name = "reserveReturn = {0}, roiCoef = {1}, profitability = {2}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //ReserveReturn
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN + 10,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                {StrategyAverageRoiMap.MIN_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                {StrategyAverageRoiMap.MAX_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                //RoiCoef
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF + 1000000L,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF + 6000L,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF + 4000L,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF + 5000L,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        0L,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.MIN_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY},
                //Profitability
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY + 1000000L},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY + 4000L},
                //DIRECT-46926
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY + 6000L},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.DEFAULT_PROFITABILITY + 5000L},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.MIN_PROFITABILITY},
                {StrategyAverageRoiMap.DEFAULT_RESERVE_RETURN,
                        StrategyAverageRoiMap.DEFAULT_ROI_COEF,
                        StrategyAverageRoiMap.MAX_PROFITABILITY}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 100L, 100L);

        /*
        log.info("Обновим стратегию кампании на AverageRoi");
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(
                new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                                .withAverageRoi(new StrategyAverageRoiMap()
                                                        .defaultStrategyAverageRoi()
                                                        .withGoalId(goalId.longValue())
                                                        .withProfitability(StrategyAverageRoiMap
                                                        .DEFAULT_PROFITABILITY)))
                                        .withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff()))));*/

        strategyMap = new TextCampaignStrategyMap()
                .withSearch(new TextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                        .withAverageRoi(new StrategyAverageRoiMap()
                                .withGoalId(goalId)
                                .withReserveReturn(reserveReturn)
                                .withRoiCoef(roiCoef)
                                .withProfitability(profitability)))
                .withNetwork(new TextCampaignNetworkStrategyMap().defaultNetworkDefault());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1151")
    public void roiOptimizationTest() {
        UpdateResponse response = api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.success())
                        .perl(ExpectedResult.warnings(campaignId,
                                new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC))
                        ));
        assumeThat("получили результаты обновления кампании", response.getUpdateResults(), hasSize(1));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(response.getUpdateResults().get(0).getId()))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());
        assumeThat("получили стратегию кампании для Search", actualStrategy.getSearch(), notNullValue());

        StrategyAverageRoiMap expectedStrategyParams = new StrategyAverageRoiMap()
                .withGoalId(goalId)
                .withReserveReturn(reserveReturn)
                .withRoiCoef(Money.valueOf(roiCoef).bidShort().setScale(2, RoundingMode.DOWN).bidLong().longValue())
                .withProfitability(
                        Money.valueOf(profitability).bidShort().setScale(2, RoundingMode.DOWN).bidLong().longValue())
                .withWeeklySpendLimit(null)
                .withBidCeiling(null);

        assertThat("получили корректные стратегии", actualStrategy.getSearch().getAverageRoi(),
                beanDifferV5((StrategyAverageRoi) expectedStrategyParams.getBean()));
    }
}
