package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy.averageroi;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 04.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра GoalId при обновлении кампании со стратегией AverageRoi")
@Tag(TagDictionary.TRUNK)
public class StrategyAverageRoiGoalIdNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static Long campaignId;
    private TextCampaignStrategyMap strategyMap;
    private static final List<Long> goals = MetrikaGoals.getGoalsForLogin(client, 2);
    ;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long goalId;

    @Parameterized.Parameter(value = 2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Оптимизация по всем целям", 0L,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.ALL_GOALS_OPTIMIZATION_IS_PROHIBITED)))
                },
                {"Отрицательное значение", -1L,
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(5005,
                                                Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER, "GoalId")))
                                .perl(ExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetails.INCORRECT_GOAL_SET)))
                },
                {"Несуществующая цель", 123456L,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.SPECIFIED_GOAL_NOT_FOUND)))
                },
                {"Не заданы ключевые цели", 13L,
                        JavaOrPerlExpectedResult.both(ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.ROI_MEANINGFUL_GOALS_IS_NOT_SET)))
                },
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void prepareCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goals.get(0), 0L, 100L);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goals.get(1), 15L, 100L);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        strategyMap = new TextCampaignStrategyMap()
                .withSearch(new TextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                        .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(goalId)))
                .withNetwork(new TextCampaignNetworkStrategyMap().defaultServingOff());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1152")
    public void goalIdNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(strategyMap))),
                expectedResult);
    }
}
