package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy.bids;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.keywords.KeywordGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageCpaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyAverageRoiMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumConversionRateMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordGetItemMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 10.09.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Проверка ограничения ставок параметром BidCeiling при переключении с ручных стратегий на автоматические на поиске/сети")
@Tag(TagDictionary.TRUNK)
public class StrategyManualToAutoBidCeilingLimitTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static TextCampaignStrategyMap strategyMap;
    private static Integer userShard;
    private Long campaignId;
    private Long groupId;
    private Long adId;
    private Long keywordId;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private static final Money defaultBid = moneyCurrency.getMinPrice().multiply(10L).getNext();

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyAddMap searchStrategyPrevious;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyAddMap networkStrategyPrevious;

    @Parameterized.Parameter(value = 3)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 4)
    public TextCampaignNetworkStrategyMap networkStrategy;

    @Parameterized.Parameter(value = 5)
    public Money expectedBid;

    @Parameterized.Parameter(value = 6)
    public Money expectedContextBid;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"Search: Ручная на MaximumClicks",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .withBidCeiling(defaultBid.bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        defaultBid,
                        moneyCurrency.getMinPrice()},
                {"Search: Ручная на MaximumConversionRate",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                                .withGoalId(goalId)
                                .withBidCeiling(defaultBid.bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        defaultBid,
                        moneyCurrency.getMinPrice()},
                {"Search: Ручная на AverageCpa",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                                .withAverageCpa(new StrategyAverageCpaMap()
                                .withGoalId(goalId)
                                .withBidCeiling(defaultBid.bidLong().longValue())
                                .withAverageCpa(moneyCurrency.getMinAveragePrice().bidLong().longValue())),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        defaultBid,
                        moneyCurrency.getMinPrice()},
                {"Search: Ручная на AverageRoi",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff(),
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(goalId)
                                .withBidCeiling(defaultBid.bidLong().longValue())),
                        new TextCampaignNetworkStrategyMap().defaultServingOff(),
                        defaultBid,
                        moneyCurrency.getMinPrice()},

                {"Network: MaximumCoverage на MaximumClicks",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                                .withBidCeiling(defaultBid.bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        moneyCurrency.getMinPrice(),
                        defaultBid},

                {"Network: MaximumCoverage на MaximumConversionRate",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                                .withGoalId(goalId)
                                .withBidCeiling(defaultBid.bidLong().longValue())
                                .withWeeklySpendLimit(moneyCurrency.getMinWeeklyBudgetAmount().bidLong().longValue())),
                        moneyCurrency.getMinPrice(),
                        defaultBid},
                {"Network: MaximumCoverage на AverageCpa",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA)
                                .withAverageCpa(new StrategyAverageCpaMap()
                                .withGoalId(goalId)
                                .withBidCeiling(defaultBid.bidLong().longValue())
                                .withAverageCpa(moneyCurrency.getMinAveragePrice().bidLong().longValue())),
                        moneyCurrency.getMinPrice(),
                        defaultBid},
                {"Network: MaximumCoverage на AverageRoi",
                        new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                                .withAverageRoi(new StrategyAverageRoiMap()
                                .defaultStrategyAverageRoi()
                                .withGoalId(goalId)
                                .withBidCeiling(defaultBid.bidLong().longValue())),
                        moneyCurrency.getMinPrice(),
                        defaultBid},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void getShard() {
        userShard = api.userSteps.clientFakeSteps().getUserShard(client);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        List<Long> ids = api.userSteps.campaignSteps().campaignsAddWithCheck(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategyPrevious)
                                .withNetwork(networkStrategyPrevious))));
        assumeThat("создана кампания", ids, hasSize(1));
        campaignId = ids.get(0);
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId, 100L, 100L);
        groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(groupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(groupId);

        //Установка ставок через сервис Bids
        api.userSteps.bidsSteps().bidsSet(new SetRequestMap().withBids(
                new BidSetItemMap()
                        .withKeywordId(keywordId)
                        .withBid(defaultBid.getNext().bidLong().longValue())
                        .withContextBid(defaultBid.getNext().bidLong().longValue())), null);
        strategyMap = new TextCampaignStrategyMap()
                .withSearch(searchStrategy)
                .withNetwork(networkStrategy);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1159")
    public void bidCeilingLimitationTest() {
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));
        List<KeywordGetItem> keywords = api.userSteps.keywordsSteps().keywordsGetById(keywordId);
        assumeThat("получили ключевое слово", keywords, hasSize(1));

        KeywordGetItemMap expectedKeyword = new KeywordGetItemMap()
                .withBid(expectedBid.bidLong().longValue())
                .withContextBid(expectedContextBid.bidLong().longValue());

        assertThat("корректные ставки ключевого слова", keywords.get(0), beanEquivalentV5(expectedKeyword.getBean()));
    }
}
