package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy.change;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.clients.ClientFieldEnum;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Cценарий проверки переключения стратегии кампании с MaximumConversionRate на MaximumClicks")
@Issue("https://st.yandex-team.ru/DIRECT-63868")
public class FromMaximumConversionRateToMaximumClicksTest {
    private static final String LOGIN = CampaignsLogins.CHANGE_STRATEGY_CLIENT;
    private static final Long goalsCount = 100L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long goalId = MetrikaGoals.getGoalForLogin(LOGIN);
    private Currency currency;

    @Before
    public void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        com.yandex.direct.api.v5.clients.GetResponse clientResponse = api.userSteps.clientsStepsV5().clientsGet(
                new ru.yandex.autotests.directapi.model.api5.clients.GetRequestMap()
                        .withFieldNames(ClientFieldEnum.CURRENCY));

        assumeThat("данные клиента получена", clientResponse.getClients(), hasSize(1));

        currency = Currency.valueOf(clientResponse.getClients().get(0).getCurrency().value());

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalId.longValue(), goalsCount, goalsCount);

        TextCampaignSearchStrategyMap searchStrategy = new TextCampaignSearchStrategyMap()
                .defaultWbMaximumConversionRate(currency, goalId.longValue());

        TextCampaignNetworkStrategyMap networkStrategy = new TextCampaignNetworkStrategyMap().defaultNetworkDefault();

        UpdateRequestMap updateRequestMap = new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap().withId(campaignId).withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyMap().withSearch(searchStrategy)
                                .withNetwork(networkStrategy))));

        api.userSteps.campaignSteps().campaignsUpdateWithCheck(updateRequestMap);
    }

    @After
    public void cleanup() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps()
                .deleteCampMetrikaGoals(campaignId, goalId.longValue());
    }

    @Test
    public void changeStrategyTest() {
        TextCampaignSearchStrategyMap textCampaignSearchStrategyMap = new TextCampaignSearchStrategyMap()
                .defaultWbMaximumClicks(currency);

        UpdateRequestMap updateRequestMap = new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap().withId(campaignId).withTextCampaign(new TextCampaignUpdateItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyMap().withSearch(textCampaignSearchStrategyMap))));

        api.userSteps.campaignSteps().campaignsUpdateWithCheck(updateRequestMap);

        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap().withIds(campaignId))
                .withFieldNames(CampaignFieldEnum.ID)
                .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY));

        assumeThat("кампания получена", getResponse.getCampaigns(), hasSize(1));

        assertThat("кампания обновилась корректно",
                getResponse.getCampaigns().get(0),
                beanDifferV5(new CampaignGetItemMap()
                        .withId(campaignId)
                        .withTextCampaign(
                                new TextCampaignGetItemMap().withBiddingStrategy(
                                        new TextCampaignStrategyMap()
                                                .withSearch(textCampaignSearchStrategyMap)
                                                .withNetwork(
                                                        new TextCampaignNetworkStrategyMap().withBiddingStrategyType(
                                                                TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT))))
                        .getBean()));
    }
}
