package ru.yandex.autotests.direct.api.campaigns.update.textcampaign.strategy.maximumclicks;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyMaximumClicksMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.nullValue;

/**
 * Created by chicos on 07.09.2015.
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@RunWith(Parameterized.class)
@Description("Негативные сценарии проверки параметра WeeklySpendLimit при обновлении кампании со стратегией " +
        "MaximumClicks")
public class StrategyMaximumClicksWeeklySpendLimitNegativeTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static MoneyCurrency moneyCurrency = MoneyCurrency.get(currency);

    private static final Money minLimit = moneyCurrency.getMinWeeklyBudgetAmount();
    private static final Money maxLimit = moneyCurrency.getMaxWeeklyBudgetAmount();

    private Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public StrategyMaximumClicksMap params;

    @Parameterized.Parameter(value = 2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                //DIRECT-45834
                {"Нулевое значение", new StrategyMaximumClicksMap().withWeeklySpendLimit(0L),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
                                        "WeeklySpendLimit",
                                        minLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                                .perl(ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(
                                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Arrays.asList(new Notification(4000, Api5ErrorDetails
                                        .WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription())))),
                },
                {"Отрицательное значение", new StrategyMaximumClicksMap().withWeeklySpendLimit(-1L),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
                                        "WeeklySpendLimit",
                                        minLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                                .perl(ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(
                                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Arrays.asList(new Notification(4000, Api5ErrorDetails
                                        .WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription()))))
                },
                {"Значение меньше минимального",
                        new StrategyMaximumClicksMap().withWeeklySpendLimit(
                                minLimit.getPrevious().bidLong().longValue()),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
                                        "WeeklySpendLimit",
                                        minLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                                .perl(ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(
                                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Arrays.asList(new Notification(4000, Api5ErrorDetails
                                        .WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
                                        minLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription()))))
                },
                {"Значение больше максимального",
                        new StrategyMaximumClicksMap().withWeeklySpendLimit(maxLimit.getNext().bidLong().longValue()),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.VALUE_MUST_NOT_BE_GREATER_THAN,
                                        "WeeklySpendLimit",
                                        maxLimit.stringValue(MoneyFormat.WITHOUT_EXTRA_ZEROS))))
                                .perl(ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(
                                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Arrays.asList(new Notification(4000, Api5ErrorDetails.WEEKLY_LIMIT_IS_TOO_HIGH,
                                        maxLimit.stringValue(MoneyFormat.TWO_DIGITS_POINT_SEPARATED),
                                        moneyCurrency.getApiDescription()))))
                },
                //DIRECT-46116
                {"Значение бюджета меньше максимальной ставки",
                        new StrategyMaximumClicksMap()
                                .withWeeklySpendLimit(minLimit.bidLong().longValue())
                                .withBidCeiling(MoneyCurrency.get(currency).getMaxPrice().bidLong().longValue()),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(new Notification(4000,
                                        Api5ErrorDetailsJava.MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
                                        "BidCeiling")))
                                .perl(ExpectedResult.create(nullValue(),
                                Arrays.asList(
                                        new Notification(10165, Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED,
                                                capitalize(
                                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                        new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                                TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC)),
                                Arrays.asList(new Notification(4000,
                                        Api5ErrorDetails.WEEKLY_BUDGET_MUST_BE_GREATER_THAN_MAXIMUM_BID))))
                }
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1165")
    public void weeklyLimitNegativeTest() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap()
                                                .withBiddingStrategyType(
                                                        TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                                                .withWbMaximumClicks(params))
                                        .withNetwork(new TextCampaignNetworkStrategyMap().defaultNetworkDefault())))),
                expectedResult);
    }
}
