package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by semkagtn on 28.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сохранения значения поля BidPercent в базе данных при различных значениях SuspendOnHolidays")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class HolidayScheduleBidPercentSaveToDatabaseTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    private static final int OLD_BID_PERCENT = 50;
    private static final int NEW_BID_PERCENT = 80;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(OLD_BID_PERCENT)))
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .defaultMobileAppCampaign()));
    }

    @Test
    @Description("Запрос с указанием BidPercent и SuspendOnHolidays = NO")
    @ru.yandex.qatools.allure.annotations.TestCaseId("1191")
    public void requestWithBidPercentWhenSuspendOnHolidaysNo() {
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTimeTargeting(new TimeTargetingMap()
                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(NEW_BID_PERCENT)))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        Integer actualBidPercent =
                campaign.getTimeTargeting().getHolidaysSchedule().getValue().getBidPercent();

        assertThat("значение поля BidPercent было сохранено верно", actualBidPercent, equalTo(NEW_BID_PERCENT));
    }

    @Test
    @Description("Запрос с указанием BidPercent и SuspendOnHolidays = YES")
    @ru.yandex.qatools.allure.annotations.TestCaseId("1190")
    public void requestWithBidPercentWhenSuspendOnHolidaysYes() {
        api.userSteps.campaignSteps()
                .shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withTimeTargeting(new TimeTargetingMap()
                                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                                .withSuspendOnHolidays(YesNoEnum.YES)
                                                .withBidPercent(NEW_BID_PERCENT)))),
                        ExpectedResult
                                .errorsIgnoringDetails(new Notification(4000,
                                        Api5ErrorDetails.HOLIDAY_SHEDULE_CANT_CONTAINS_FIELD,
                                        capitalize(TimeTargetingOnPublicHolidaysMap.BID_PERCENT))));
    }
}
