package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 28.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка валидации поля BidPercent")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class HolidayScheduleBidPercentValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public Integer bidPercent;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "BidPercent = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {TimeTargetingOnPublicHolidaysMap.MIN_BID_PERCENT, ExpectedResult.success()},
                {TimeTargetingOnPublicHolidaysMap.MAX_BID_PERCENT, ExpectedResult.success()},
                {null, ExpectedResult.success()},
                {TimeTargetingOnPublicHolidaysMap.MIN_BID_PERCENT - 10,
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_FROM_TO,
                                TimeTargetingOnPublicHolidaysMap.MIN_BID_PERCENT,
                                TimeTargetingOnPublicHolidaysMap.MAX_BID_PERCENT))},
                {TimeTargetingOnPublicHolidaysMap.MAX_BID_PERCENT + 10,
                        ExpectedResult.errors(new Notification(4000,
                                Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_BE_FROM_TO,
                                TimeTargetingOnPublicHolidaysMap.MIN_BID_PERCENT,
                                TimeTargetingOnPublicHolidaysMap.MAX_BID_PERCENT))},
                {55, ExpectedResult.errors(new Notification(4000,
                        Api5ErrorDetails.HOLIDAY_BID_PERCENT_MUST_DIV_BY_10))},
        });
    }

    private static long campaignId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1192")
    public void requestWithBidPercent() {
        api.userSteps.campaignSteps()
                .shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withTimeTargeting(new TimeTargetingMap()
                                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                                .withSuspendOnHolidays(YesNoEnum.NO)
                                                .withStartHour(10)
                                                .withEndHour(20)
                                                .withBidPercent(bidPercent)))),
                        expectedResult);
    }
}
