package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 04.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сохранения значений StartHours, EndHours в полях структуры HolidaySchedule при обновлении")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class HolidayScheduleSaveToDatabaseStartEndHoursTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    private static final int START_HOUR = 5;
    private static final int END_HOUR = 19;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Description("Проверка сохранения значения поля StartHour")
    @ru.yandex.qatools.allure.annotations.TestCaseId("1193")
    public void checkStartHourFieldWithNeedShowYes() {
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTimeTargeting(new TimeTargetingMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(START_HOUR)
                                .withEndHour(END_HOUR)))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        Integer actualStartHour = campaign.getTimeTargeting().getHolidaysSchedule().getValue().getStartHour();
        assertThat("значение поля StartHour соответствует ожидаемому", actualStartHour, equalTo(START_HOUR));
    }

    @Test
    @Description("Проверка сохранения значения поля EndHour")
    @ru.yandex.qatools.allure.annotations.TestCaseId("1194")
    public void checkEndHourFieldWithNeedShowYes() {
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTimeTargeting(new TimeTargetingMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(START_HOUR)
                                .withEndHour(END_HOUR)))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        Integer actualStartHour = campaign.getTimeTargeting().getHolidaysSchedule().getValue().getEndHour();
        assertThat("значение поля EndHour соответствует ожидаемому", actualStartHour, equalTo(END_HOUR));
    }
}
