package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by samedy on 11.01.16.
 * https://st.yandex-team.ru/TESTIRT-8160
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка изменения значений SuspendOnHolidays (Yes <-> No)")
@Issue("https://st.yandex-team.ru/DIRECT-49770")
@RunWith(Parameterized.class)
public class HolidayScheduleSaveToDatabaseSuspendOnHolidaysTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long campaignId;

    @Parameterized.Parameter(0)
    public YesNoEnum oldValue;

    @Parameterized.Parameter(1)
    public Integer oldStartHour;

    @Parameterized.Parameter(2)
    public Integer oldEndHour;

    @Parameterized.Parameter(3)
    public YesNoEnum newValue;

    @Parameterized.Parameter(4)
    public Integer newStartHour;

    @Parameterized.Parameter(5)
    public Integer newEndHour;

    @Parameterized.Parameters(name = "oldValue = {0}, newValue = {3}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {YesNoEnum.NO, 1, 5, YesNoEnum.YES, null, null},
                {YesNoEnum.YES, null, null, YesNoEnum.NO, 1, 5},
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withTimeTargeting(new TimeTargetingAddMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(oldValue)
                                .withStartHour(oldStartHour)
                                .withEndHour(oldEndHour))));
    }

    @Test
    @Description("Проверка изменения поля SuspendOnHolidays")
    @ru.yandex.qatools.allure.annotations.TestCaseId("1195")
    public void checkUpdateSuspendOnHolidaysFieldYes() {

        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withTimeTargeting(new TimeTargetingMap()
                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(newValue)
                                .withStartHour(newStartHour)
                                .withEndHour(newEndHour)))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        YesNoEnum actualSuspendOnHolidays =
                campaign.getTimeTargeting().getHolidaysSchedule().getValue().getSuspendOnHolidays();
        assertThat("значение поля SuspendOnHolidays соответствует ожидаемому", actualSuspendOnHolidays,
                equalTo(newValue));
    }
}
