package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 08.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сохранения yes-no значений в полях структуры HolidaySchedule при обновлении")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class HolidayScheduleSaveToDatabaseYesNoValuesTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public YesNoEnum oldValue;

    @Parameterized.Parameter(1)
    public YesNoEnum newValue;

    @Parameterized.Parameters(name = "Value = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {YesNoEnum.NO, YesNoEnum.YES},
                {YesNoEnum.YES, YesNoEnum.NO},
        });
    }

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign()
                .withNotification(new NotificationMap()
                        .withEmailSettings(new EmailSettingsMap()
                                .withSendWarnings(oldValue))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1196")
    public void checkSendWarnings() {
        NotificationMap notificationMap = new NotificationMap().withEmailSettings(
                new EmailSettingsMap().withSendWarnings(newValue));

        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withNotification(notificationMap)));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignId);
        assumeThat("была получена одна кампания", campaigns, hasSize(1));

        CampaignGetItem actualCampaign = campaigns.get(0);
        CampaignGetItem expectedCampaign = (CampaignGetItem) new CampaignGetItemMap()
                .withNotification(notificationMap).getBean();
        assertThat("значение events было сохранено верно", actualCampaign, beanEquivalent(expectedCampaign));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1197")
    public void checkSendAccountNews() {
        NotificationMap notificationMap = new NotificationMap().withEmailSettings(
                new EmailSettingsMap().withSendAccountNews(newValue));

        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .withNotification(notificationMap)));

        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignId);
        assumeThat("была получена одна кампания", campaigns, hasSize(1));

        CampaignGetItem actualCampaign = campaigns.get(0);
        CampaignGetItem expectedCampaign = (CampaignGetItem) new CampaignGetItemMap()
                .withNotification(notificationMap).getBean();
        assertThat("значение events было сохранено верно", actualCampaign, beanEquivalent(expectedCampaign));
    }
}
