package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 08.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка валидации полей StartHour и EndHour в структуре HolidaySchedule при обновлении")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class HolidayScheduleStartEndHourValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public int startHour;

    @Parameterized.Parameter(1)
    public int endHour;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "StartHour = {0}, EndHour = {1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {0, 20, ExpectedResult.success()},
                {23, 24, ExpectedResult.success()},
                {5, 24, ExpectedResult.success()},
                {0, 1, ExpectedResult.success()},
                {15, 15, ExpectedResult.errorsIgnoringDetails(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_LESS_THEN_FIELD,
                        capitalize(TimeTargetingOnPublicHolidaysMap.START_HOUR),
                        capitalize(TimeTargetingOnPublicHolidaysMap.END_HOUR)))},
                {16, 12, ExpectedResult.errorsIgnoringDetails(new Notification(5005, Api5ErrorDetails.FIELD_MUST_BE_LESS_THEN_FIELD,
                        capitalize(TimeTargetingOnPublicHolidaysMap.START_HOUR),
                        capitalize(TimeTargetingOnPublicHolidaysMap.END_HOUR)))},
                {-1, 12, ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_FROM_TO,
                        capitalize(TimeTargetingOnPublicHolidaysMap.START_HOUR), 0, 23))},
                {4, 25, ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_FROM_TO,
                        capitalize(TimeTargetingOnPublicHolidaysMap.END_HOUR), 1, 24))},
                {-1, 25, ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_FROM_TO,
                                capitalize(TimeTargetingOnPublicHolidaysMap.START_HOUR), 0, 23),
                        new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_FROM_TO,
                                capitalize(TimeTargetingOnPublicHolidaysMap.END_HOUR), 1, 24))},
        });
    }

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1198")
    public void checkStartEndHourValidation() {
        api.userSteps.campaignSteps()
                .shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withTimeTargeting(new TimeTargetingMap()
                                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                                .withSuspendOnHolidays(YesNoEnum.NO)
                                                .withStartHour(startHour)
                                                .withEndHour(endHour)))),
                        expectedResult);
    }
}
