package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.Arrays;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 25.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка обязательных полей: в структуре HolidaySchedule. При значении SuspendOnHolidays = NO поля" +
        " StartHour и EndHour являются обязательными")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class HolidayScheduleStartEndHoursMandatoryFieldsTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Integer startHour;

    @Parameterized.Parameter(2)
    public Integer endHour;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"запрос без StartHour", null, 10},
                {"запрос без EndHour", 5, null},
                {"запрос без StartHour и EndHour", null, null},
        });
    }

    private static long campaignId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1199")
    public void requestWithoutSomeMandatoryFields() {
        api.userSteps.campaignSteps()
                .shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withTimeTargeting(new TimeTargetingMap()
                                        .withConsiderWorkingWeekends(YesNoEnum.YES)
                                        .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                                .withSuspendOnHolidays(YesNoEnum.NO)
                                                .withStartHour(startHour)
                                                .withEndHour(endHour)))),
                        ExpectedResult
                                .errorsIgnoringDetails(new Notification(5000, Api5ErrorDetails.START_END_HOURS_MUST_BE_ENTERED)));
    }
}
