package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 08.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка того, что расширенные настройки таймтаргетинга доступны только для кампаний " +
        "с не автобюджетными стратегиями")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class ScheduleItemAutoStrategyTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1200")
    public void scheduleItemZeroBidAdjustmentAutoStrategy() {
        List<String> schedule = new ArrayList<>();
        schedule.add("1,50,50,50,50,50,50,20,50,50,50,50,50,60,50,110,50,50,50,50,50,50,50,50,0");

        List<String> expectedSchedule = new ArrayList<>();
        expectedSchedule.add("1," + String.join(",", Collections.nCopies(23, "100")) + ",0");
        for (int i = 2; i <= 7; i++) {
            expectedSchedule.add(i + "," + String.join(",", Collections.nCopies(24, "100")));
        }
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(campaignId)
                                .withTimeTargeting(new TimeTargetingMap()
                                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                                        .withSchedule(schedule.toArray(new String[schedule.size()])))
                                .withTextCampaign(new TextCampaignUpdateItemMap()
                                        .withBiddingStrategy(new TextCampaignStrategyMap()
                                                .withSearch(new TextCampaignSearchStrategyMap()
                                                        .defaultWbMaximumClicks(Currency.RUB))
                                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultNetworkDefault())))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.success())
                        .perl(ExpectedResult.warnings(new Notification(10165,
                                        Api5ErrorDetails.PARAM_WILL_NOT_BE_CHANGED, capitalize(
                                        StrategyNetworkDefaultAddMap.LIMIT_PERCENT)),
                                new Notification(10163, Api5ErrorDetails.SETTING_WILL_NOT_BE_CHANGED,
                                        TextCampaignSettingsEnum.MAINTAIN_NETWORK_CPC))));
    }
}
