package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by semkagtn on 08.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка сохранения поля Items в структуре Schedule при обновлении")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
public class ScheduleItemsSaveToDatabaseTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1202")
    public void saveScheduleItemsToDatabase() {
        List<String> schedule = new ArrayList<>();
        schedule.add("1,50,50,50,50,50,50,20,50,50,50,50,50,60,50,110,50,50,50,50,50,50,50,50,50");

        List<String> expectedSchedule = new ArrayList<>();
        expectedSchedule.addAll(schedule);
        for (int i = schedule.size() + 1; i <= 7; i++) {
            expectedSchedule.add(i + "," + String.join(",", Collections.nCopies(24, "100")));
        }

        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTimeTargeting(new TimeTargetingMap()
                                .withConsiderWorkingWeekends(YesNoEnum.NO)
                                .withSchedule(schedule.toArray(new String[schedule.size()])))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        List<String> actualSchedule = campaign.getTimeTargeting().getSchedule().getItems();
        assertThat("значение Schedule.items было сохранено верно",
                actualSchedule, beanEquivalent(expectedSchedule));
    }

    // Тест для DIRECT-56750
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1201")
    public void saveMixedScheduleItemsToDatabase() {
        List<String> schedule = Arrays.asList(new String[]{
                "5,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0,0",
                "1,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0",
                "2,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0",
                "3,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0",
                "4,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0"});

        List<String> expectedSchedule = new ArrayList<>();
        expectedSchedule.addAll(Arrays.asList(new String[]{
                "1,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0",
                "2,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0",
                "3,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0",
                "4,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0",
                "5,0,0,0,0,0,0,0,0,100,100,100,100,100,100,100,100,0,0,0,0,0,0,0,0"}));

        for (int i = schedule.size() + 1; i <= 7; i++) {
            expectedSchedule.add(i + "," + String.join(",", Collections.nCopies(24, "100")));
        }
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTimeTargeting(new TimeTargetingMap()
                                .withConsiderWorkingWeekends(YesNoEnum.NO)
                                .withSchedule(schedule.toArray(new String[schedule.size()])))));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);
        List<String> actualSchedule = campaign.getTimeTargeting().getSchedule().getItems();
        assertThat("значение Schedule.items было сохранено верно",
                actualSchedule, beanEquivalent(expectedSchedule));
    }
}
