package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 08.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка валидации поля Items в структуре Schedule")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ScheduleItemsValidationTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public List<String> items;

    @Parameterized.Parameter(1)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "items = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "3,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "4,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "5,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "6,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "7,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.success()},
                {Arrays.asList(
                        "1,0,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.success()},
                {Arrays.asList(
                        "1,200,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.success()},
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "3,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "4,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "5,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "6,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "7,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "7,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(9802, Api5ErrorDetails.TIME_TARGETING_HAS_REPEATED_WEEKDAYS))},
                {Arrays.asList(
                        "1,210,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_COEFS_MUST_BE_FROM_0_TO_200))},
                {Arrays.asList(
                        "1,a,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_HAS_NOT_INTEGER_COEFS))},
                {Arrays.asList(
                        "1,0.99,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_HAS_NOT_INTEGER_COEFS))},
                {Arrays.asList(
                        "1,-10,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_CANT_CONTAINS_NEGATIVE_COEFS))},
                {Arrays.asList(
                        "1,15,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_VALUES_DIV_10))},
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_COEFS_FOR_24_HOURS))},
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_COEFS_FOR_24_HOURS))},
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(9802, Api5ErrorDetails.TIME_TARGETING_HAS_REPEATED_WEEKDAYS))},
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "8,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_DAYS_FROM_1_TO_7))},
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "0,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_DAYS_FROM_1_TO_7))},
                {Arrays.asList(
                        "a,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_DAYS_FROM_1_TO_7))},
                {Arrays.asList(
                        "-1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_DAYS_FROM_1_TO_7))},
                {Arrays.asList(
                        "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
                        "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,0,0,0,0,0,0,0,0,0",
                        "3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0",
                        "4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0",
                        "5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0",
                        "6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0",
                        "7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"
                ), ExpectedResult.errorsIgnoringDetails(
                        new Notification(5005, Api5ErrorDetails.TIME_TARGETING_MUST_CONTAINS_COEFS_FOR_24_HOURS))},
        });
    }

    private long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1203")
    public void checkScheduleItemsValidation() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTimeTargeting(new TimeTargetingMap()
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                .withSchedule(items.toArray(new String[items.size()])))),
                expectedResult);
    }
}
