package ru.yandex.autotests.direct.api.campaigns.update.timetargeting;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Ещё один тест на проверку частичного обновления TimeTargeting")
@Issue("https://st.yandex-team.ru/DIRECT-161161")
@RunWith(Parameterized.class)
public class TimeTargetingPartialUpdateAnotherTest {

    private static final String LOGIN = CampaignsLogins.SINGLE_CLIENT;

    private static TimeTargetingAddMap getTimeTargetingAdd() {
        return new TimeTargetingAddMap()
                .withSchedule(TimeTargetingMap.DEFAULT_SCHEDULE)
                .withConsiderWorkingWeekends(YesNoEnum.NO)
                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                        .withSuspendOnHolidays(YesNoEnum.NO)
                        .withStartHour(10)
                        .withEndHour(20)
                        .withBidPercent(30));
    }

    private static TimeTargetingMap getTimeTargetingUpdate() {
        return new TimeTargetingMap()
                // обязательно поле, указываем всегда
                .withConsiderWorkingWeekends(YesNoEnum.NO);
    }

    private static TimeTargetingMap getTimeTargetingResult() {
        return new TimeTargetingMap()
                .withSchedule(TimeTargetingMap.DEFAULT_SCHEDULE)
                .withConsiderWorkingWeekends(YesNoEnum.NO)
                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                        .withSuspendOnHolidays(YesNoEnum.NO)
                        .withStartHour(10)
                        .withEndHour(20)
                        .withBidPercent(30));
    }

    private static final String[] TEST_SCHEDULE =
            {"1,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200,200,200",
                    "2,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200,200,200,190",
                    "3,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200,200,200,190,180",
                    "4,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200,200,200,190,180,170",
                    "5,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200,200,200,190,180,170,160",
                    "6,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200,200,200,190,180,170,160,150",
                    "7,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200,200,200,190,180,170,160,150,140"};

    private static final String[] SCHEDULE_100 = {
            "1,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "2,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "3,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "4,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "5,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "6,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "7,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100"
    };

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public TimeTargetingAddMap initialTimeTargeting;

    @Parameterized.Parameter(2)
    public TimeTargetingMap updateTimeTargeting;

    @Parameterized.Parameter(3)
    public TimeTargetingMap expectedTimeTargeting;

    @Parameterized.Parameters(name = "{0}")
    public static Iterable<Object[]> data() {

        return Arrays.asList(new Object[][]{
                {"обновление одной записи в Schedule",

                        getTimeTargetingAdd(),

                        getTimeTargetingUpdate()
                                .withSchedule
                                ("2,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200," +
                                                "200,200",
                                        "7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10"),

                        getTimeTargetingResult()
                                // непереданные дни заполняются дефолтными 100, по доке
                                // https://yandex.ru/dev/direct/doc/ref-v5/campaigns/update.html#input__TimeTargeting
                                .withSchedule
                                ("1,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "2,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200," +
                                                "200,200,200,200",
                                        "3,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "4,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "5,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "6,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10")
                },

                {"обновление одной записи в Schedule 2",

                        new TimeTargetingAddMap()
                                .withSchedule(TimeTargetingMap.DEFAULT_SCHEDULE)
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.YES)),

                        new TimeTargetingMap()
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                .withSchedule
                                ("2,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200," +
                                                "200,200",
                                        "7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10"),

                        new TimeTargetingMap()
                                .withSchedule(TimeTargetingMap.DEFAULT_SCHEDULE)
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                        .withSuspendOnHolidays(YesNoEnum.YES))
                                // непереданные дни заполняются дефолтными 100, по доке
                                // https://yandex.ru/dev/direct/doc/ref-v5/campaigns/update.html#input__TimeTargeting
                                .withSchedule
                                ("1,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "2,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200," +
                                                "200,200,200,200",
                                        "3,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "4,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "5,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "6,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10")
                },

                {"обновление одной записи в Schedule и ConsiderWorkingWeekends",

                        getTimeTargetingAdd()
                                .withConsiderWorkingWeekends(YesNoEnum.NO),

                        getTimeTargetingUpdate()
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                .withSchedule
                                ("2,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200,200,200," +
                                                "200,200",
                                        "7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10"),

                        getTimeTargetingResult()
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                // непереданные дни заполняются дефолтными 100, по доке
                                // https://yandex.ru/dev/direct/doc/ref-v5/campaigns/update.html#input__TimeTargeting
                                .withSchedule
                                ("1,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "2,10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,170,180,190,200," +
                                                "200,200,200,200",
                                        "3,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "4,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "5,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "6,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100," +
                                                "100,100,100,100,100,100",
                                        "7,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10")
                },

                {"обновление всех записей в Schedule",

                        getTimeTargetingAdd(),

                        getTimeTargetingUpdate()
                                .withSchedule(TEST_SCHEDULE),

                        getTimeTargetingResult()
                                .withSchedule(TEST_SCHEDULE)
                },

                {"обновление ConsiderWorkingWeekends",

                        getTimeTargetingAdd(),

                        getTimeTargetingUpdate()
                                .withConsiderWorkingWeekends(YesNoEnum.YES),

                        getTimeTargetingResult()
                                // Schedule сбрасывается не только при обновлении Schedule но и вообще всегда
                                // это не правильно фиксим в https://st.yandex-team.ru/DIRECT-162184
                                .withSchedule(SCHEDULE_100)
                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                },

                {"обновление SuspendOnHolidays",

                        getTimeTargetingAdd()
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(30)),

                        getTimeTargetingUpdate()
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.YES)),

                        getTimeTargetingResult()
                                // Schedule сбрасывается не только при обновлении Schedule но и вообще всегда
                                // это не правильно фиксим в https://st.yandex-team.ru/DIRECT-162184
                                .withSchedule(SCHEDULE_100)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.YES))
                },

                {"обновление StartHour, EndHour",

                        getTimeTargetingAdd()
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(30)),

                        getTimeTargetingUpdate()
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(11)
                                .withEndHour(19)),

                        getTimeTargetingResult()
                                // Schedule сбрасывается не только при обновлении Schedule но и вообще всегда
                                // это не правильно фиксим в https://st.yandex-team.ru/DIRECT-162184
                                .withSchedule(SCHEDULE_100)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(11)
                                .withEndHour(19)
                                // если указана структура HolidaysSchedule, но не указан BidPercent - то BidPercent
                                // сбрасывается в 100
                                .withBidPercent(100))
                },

                {"обновление BidPercent",

                        getTimeTargetingAdd()
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(30)),

                        getTimeTargetingUpdate()
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(40)),

                        getTimeTargetingResult()
                                // Schedule сбрасывается не только при обновлении Schedule но и вообще всегда
                                // это не правильно фиксим в https://st.yandex-team.ru/DIRECT-162184
                                .withSchedule(SCHEDULE_100)
                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                .withSuspendOnHolidays(YesNoEnum.NO)
                                .withStartHour(10)
                                .withEndHour(20)
                                .withBidPercent(40))
                }
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("244")
    public void testTimeTargetingUpdate() {
        Long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()
                        .withTimeTargeting(initialTimeTargeting));

        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignId)
                .defaultCampaignUpdateItem()
                .withTimeTargeting(updateTimeTargeting)));

        CampaignGetItem campaign =
                api.userSteps.campaignSteps().campaignsGet(campaignId, CampaignFieldEnum.TIME_TARGETING);

        assertThat("вернулась правильная кампания", campaign.getTimeTargeting(),
                beanDifferV5(expectedTimeTargeting.getBean()));

    }

}
