package ru.yandex.autotests.direct.api.campext;

import java.util.Set;

import com.google.common.collect.ImmutableSet;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSettingsGetEnum;

/**
 * Настройки кампании в api5, которые не нужно проверять
 * в тестах UpdateAndGetSettingsExtAllNoTest и UpdateAndGetSettingsExtAllYesTest
 * <p>
 * REQUIRE_SERVICING - в теории можно проверить,
 * но не с клиентом GET_SERV_CLIENT (у него нет counter)
 */
public class CampaignsExtDeprecatedSettings {
    public static Set<TextCampaignSettingsEnum> TEXT_CAMPAIGN_DEPRECATED_SETTINGS = ImmutableSet.of(
            TextCampaignSettingsEnum.REQUIRE_SERVICING,
            TextCampaignSettingsEnum.ENABLE_AUTOFOCUS,
            TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS,
            TextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING
    );
    public static Set<TextCampaignSettingsGetEnum> TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET = ImmutableSet.of(
            TextCampaignSettingsGetEnum.REQUIRE_SERVICING,
            TextCampaignSettingsGetEnum.ENABLE_AUTOFOCUS,
            TextCampaignSettingsGetEnum.ENABLE_RELATED_KEYWORDS,
            TextCampaignSettingsGetEnum.ENABLE_BEHAVIORAL_TARGETING,
            TextCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED,
            TextCampaignSettingsGetEnum.TURBO_APPS_ENABLED
    );

    public static Set<DynamicTextCampaignSettingsEnum> DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS = ImmutableSet.of(
            DynamicTextCampaignSettingsEnum.REQUIRE_SERVICING,
            DynamicTextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING
    );
    public static Set<DynamicTextCampaignSettingsGetEnum> DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET =
            ImmutableSet.of(
            DynamicTextCampaignSettingsGetEnum.REQUIRE_SERVICING,
            DynamicTextCampaignSettingsGetEnum.ENABLE_BEHAVIORAL_TARGETING,
            DynamicTextCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED,
            DynamicTextCampaignSettingsGetEnum.TURBO_APPS_ENABLED
    );

    public static Set<ContentPromotionCampaignSettingsEnum> CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS =
            ImmutableSet.of(
            ContentPromotionCampaignSettingsEnum.REQUIRE_SERVICING
    );
    public static Set<ContentPromotionCampaignSettingsGetEnum> CONTENT_PROMOTION_CAMPAIGN_DEPRECATED_SETTINGS_GET =
            ImmutableSet.of(
            ContentPromotionCampaignSettingsGetEnum.REQUIRE_SERVICING, // поддерживается, но нельзя проверить: у
            // GET_SERV_CLIENT нет counter
            ContentPromotionCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED
    );

    public static Set<SmartCampaignSettingsEnum> SMART_CAMPAIGN_DEPRECATED_SETTINGS = ImmutableSet.of(
            SmartCampaignSettingsEnum.REQUIRE_SERVICING // поддерживается, но нельзя проверить: у GET_SERV_CLIENT нет
            // counter
    );
    public static Set<SmartCampaignSettingsGetEnum> SMART_CAMPAIGN_DEPRECATED_SETTINGS_GET = ImmutableSet.of(
            SmartCampaignSettingsGetEnum.REQUIRE_SERVICING,
            SmartCampaignSettingsGetEnum.TURBO_APPS_ENABLED,
            SmartCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED
    );
}
