package ru.yandex.autotests.direct.api.campext.add.dynamictextcampaign.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingGet;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.DynamicTextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка поля Settings в CampaignsExt")
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class AddAndGetSettingsExtTest {
    private static final String client = CampaignsLogins.SERV_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public DynamicTextCampaignSettingsEnum option;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameters(name = "option = {0}, value = {1}")
    public static Collection<Object[]> testData() {
        List<Object[]> data = new ArrayList<>();
        for (DynamicTextCampaignSettingsEnum settingsEnum : DynamicTextCampaignSettingsEnum.values()) {
            if (DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS.contains(settingsEnum)) {
                continue;
            }
            data.add(new Object[]{settingsEnum, YesNoEnum.NO});
            data.add(new Object[]{settingsEnum, YesNoEnum.YES});
        }

        return data;
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        campaignID = api.userSteps.campExtSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .defaultDynamicTextCampaign()
                                .withSettings(new DynamicTextCampaignSettingMap()
                                        .withOption(option)
                                        .withValue(settingValue))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("128")
    public void checkSettingsTest() {
        GetResponse getResponse = api.as(client).userSteps.campExtSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<DynamicTextCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getDynamicTextCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        List<YesNoEnum> value = settings.stream()
                .filter(setting -> setting.getOption()
                        .equals(DynamicTextCampaignSettingsGetEnum.valueOf(option.value())))
                .map(DynamicTextCampaignSettingGet::getValue).collect(Collectors.toList());
        assertThat("вернулся ожидаемый параметр", value, equalTo(Collections.singletonList(settingValue)));
    }
}
