package ru.yandex.autotests.direct.api.campext.add.smartcampaign.settings;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingGet;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.SmartCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.SmartCampaignSettingMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка поля Settings в CampaignsExt")
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class AddAndGetSettingsExtTest {
    private static String client = CampaignsLogins.CLIENT;
    private static final Integer counter = MetrikaGoals.getCounterForLogin(client);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public SmartCampaignSettingsEnum option;

    @Parameterized.Parameter(1)
    public YesNoEnum settingValue;

    @Parameterized.Parameters(name = "option = {0}, value = {1}")
    public static Collection<?> testData() {
        Object[][] data = new Object[][]{
                {SmartCampaignSettingsEnum.ADD_TO_FAVORITES, YesNoEnum.NO},
                {SmartCampaignSettingsEnum.ADD_TO_FAVORITES, YesNoEnum.YES},
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        campaignID = api.userSteps.campExtSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withSmartCampaign(new SmartCampaignAddItemMap()
                                .defaultSmartCampaign()
                                .withCounterId(Long.valueOf(counter))
                                .withSettings(new SmartCampaignSettingMap()
                                        .withOption(option)
                                        .withValue(settingValue))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("128")
    public void checkSettingsTest() {
        GetResponse getResponse = api.as(client).userSteps.campExtSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.SETTINGS));

        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<SmartCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getSmartCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        List<YesNoEnum> value = settings.stream()
                .filter(setting -> setting.getOption()
                        .equals(SmartCampaignSettingsGetEnum.valueOf(option.value())))
                .map(SmartCampaignSettingGet::getValue).collect(Collectors.toList());
        assertThat("вернулся ожидаемый параметр", value, equalTo(Collections.singletonList(settingValue)));
    }
}
