package ru.yandex.autotests.direct.api.campext.delete;

import java.util.List;

import com.yandex.direct.api.v5.campaignsext.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaignsext.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.emptyIterable;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 19.11.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.DELETE)
@Description("Проверка позитивных сценариев удаления кампаний")
@Tag(TagDictionary.TRUNK)
public class DeleteContentPromotionCampaignsPositiveTest {

    private static final String client = CampaignsLogins.SINGLE_CLIENT_DELETE;
    private static final String clientAccount = CampaignsLogins.SINGLE_CLIENT_DELETE_ACCOUNT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignAccount;

    private static Long campaignIdContentPromotion;
    private static Long campaignIdText;
    private static Long campaignID;
    private static Long campaignID1;
    private static Long campaignID2;

    @BeforeClass
    public static void prepareCampaigns() {
        campaignIdContentPromotion = api.as(client).userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignIdText = api.userSteps.campExtSteps().addDefaultTextCampaign();
        campaignID = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignID1 = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignID2 = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignAccount = api.as(clientAccount).userSteps.campExtSteps().addDefaultContentPromotionCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("375")
    public void deleteSingleDynamicCampaignTest() {
        api.as(client).userSteps.campExtSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.success(campaignID));
        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(campaignID);
        assertThat("кампания удалена", campaigns, emptyIterable());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("376")
    public void deleteTwoDynamicCampaignsTest() {
        api.as(client).userSteps.campExtSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID2)),
                ExpectedResult.success(campaignID1),
                ExpectedResult.success(campaignID2));
        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(campaignID1, campaignID2);
        assertThat("кампании удалены", campaigns, emptyIterable());
    }

    @Test
    @Description("Удалим мобильную кампанию клиента с подключенным общим счётом")
    @ru.yandex.qatools.allure.annotations.TestCaseId("377")
    public void deleteSingleDynamicCampaignAccountTest() {
        api.as(clientAccount).userSteps.campExtSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignAccount)),
                ExpectedResult.success(campaignAccount));
        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(campaignAccount);
        assertThat("кампания удалена", campaigns, emptyIterable());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("378")
    public void deleteCampaignsDifferentTypesTest() {
        api.as(client).userSteps.campExtSteps().shouldGetResultOn(
                Action.DELETE,
                new DeleteRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignIdText, campaignIdContentPromotion)),
                ExpectedResult.success(campaignIdText),
                ExpectedResult.success(campaignIdContentPromotion));
        List<CampaignGetItem> campaigns =
                api.userSteps.campExtSteps().getCampaigns(campaignIdText, campaignIdContentPromotion);
        assertThat("кампании удалены", campaigns, emptyIterable());
    }
}
