package ru.yandex.autotests.direct.api.campext.resume;

import java.util.List;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.CampaignStateGetEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaignsext.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 19.11.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.RESUME)
@Description("Проверка позитивных сценариев возобновления динамических текстовых кампаний")
@Tag(TagDictionary.TRUNK)
public class ResumeContentPromotionCampaignsPositiveTest {

    private static final String client = CampaignsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignIdContentPromotion;
    private static Long campaignIdText;
    private static Long campaignId;
    private static Long campaignId1;
    private static Long campaignId2;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignIdText = api.userSteps.campExtSteps().addDefaultTextCampaign();
        campaignIdContentPromotion = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignId = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignId1 = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignId2 = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        api.userSteps.campExtSteps()
                .campaignsSuspend(campaignId, campaignId1, campaignId2, campaignIdText, campaignIdContentPromotion);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("601")
    public void resumeSingleContentPromotionCampaignTest() {
        api.userSteps.campExtSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignId)),
                ExpectedResult.success(campaignId));
        CampaignGetItem campaign = api.userSteps.campExtSteps().campaignsGet(campaignId, CampaignFieldEnum.STATE);
        assertThat("корректное значение поля State после возобновления кампании", campaign.getState(),
                equalTo(CampaignStateGetEnum.OFF));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("602")
    public void resumeTwoContentPromotionCampaignsTest() {
        api.userSteps.campExtSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignId1, campaignId2)),
                ExpectedResult.success(campaignId1),
                ExpectedResult.success(campaignId2));
        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(campaignId1, campaignId2);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после остановки кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.OFF)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("603")
    public void resumeCampaignsDifferentTypesTest() {
        api.userSteps.campExtSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignIdText, campaignIdContentPromotion)),
                ExpectedResult.success(campaignIdText),
                ExpectedResult.success(campaignIdContentPromotion));
        List<CampaignGetItem> campaigns =
                api.userSteps.campExtSteps().getCampaigns(campaignIdText, campaignIdContentPromotion);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после остановки кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.OFF)));
    }
}
