package ru.yandex.autotests.direct.api.campext.update.dynamictextcampaign.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingGet;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.DynamicTextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import one.util.streamex.StreamEx;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.DynamicTextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.DynamicTextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 04.02.16.
 * https://st.yandex-team.ru/TESTIRT-8435
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-50402")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка поля Settings. Независимость изменений с YES на NO")
@RunWith(Parameterized.class)
public class UpdateAndGetSettingsExtAllYesTest {
    private static final String client = CampaignsLogins.GET_SERV_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;
    private Map<DynamicTextCampaignSettingsGetEnum, YesNoEnum> expectedSettings;
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public DynamicTextCampaignSettingsEnum option;

    @Parameterized.Parameters(name = "option = {0}")
    public static Collection testData() {
        List<Object[]> data = new ArrayList<Object[]>();
        for (DynamicTextCampaignSettingsEnum campaignSettingsEnum : DynamicTextCampaignSettingsEnum.values()) {
            if (DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS.contains(campaignSettingsEnum)) {
                continue;
            }

            data.add(new Object[]{campaignSettingsEnum});
        }
        return data;
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        expectedSettings = new HashMap<>();
        for (DynamicTextCampaignSettingsGetEnum campaignSettingsEnum : DynamicTextCampaignSettingsGetEnum.values()) {
            if (DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(campaignSettingsEnum)) {
                continue;
            }
            YesNoEnum value = campaignSettingsEnum.value().equals(option.value()) ? YesNoEnum.NO : YesNoEnum.YES;
            expectedSettings.put(campaignSettingsEnum, value);
        }

        ArrayList<DynamicTextCampaignSettingMap> settings = new ArrayList<>();
        for (DynamicTextCampaignSettingsEnum campaignSettingsEnum : DynamicTextCampaignSettingsEnum.values()) {
            if (DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS.contains(campaignSettingsEnum)) {
                continue;
            }
            settings.add(
                    new DynamicTextCampaignSettingMap().withOption(campaignSettingsEnum).withValue(YesNoEnum.YES));
        }
        campaignID = api.userSteps.campExtSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDynamicTextCampaign(new DynamicTextCampaignAddItemMap()
                                .defaultDynamicTextCampaign()
                                .withSettings(settings.toArray(new DynamicTextCampaignSettingMap[]{}))
                        ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("950")
    public void checkUpdateSettingsTest() {
        api.userSteps.campExtSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignID)
                .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                        .withSettings(new DynamicTextCampaignSettingMap()
                                .withOption(option)
                                .withValue(YesNoEnum.NO)))
        ));
        GetResponse getResponse = api.as(client).userSteps.campExtSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<DynamicTextCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getDynamicTextCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        Map<DynamicTextCampaignSettingsGetEnum, YesNoEnum> settingsMap =
                StreamEx.of(settings)
                        .mapToEntry(DynamicTextCampaignSettingGet::getOption, DynamicTextCampaignSettingGet::getValue)
                        .filterKeys(x -> !DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(x))
                        .toMap();
        assertThat("вернулся ожидаемый набор настроек", settingsMap,
                beanDiffer(expectedSettings));
    }
}
