package ru.yandex.autotests.direct.api.campext.update.smartcampaign.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingGet;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.SmartCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import one.util.streamex.StreamEx;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.SmartCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.SmartCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.SmartCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.SMART_CAMPAIGN_DEPRECATED_SETTINGS;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.SMART_CAMPAIGN_DEPRECATED_SETTINGS_GET;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-109983")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка поля Settings. Независимость изменений с YES на NO")
@RunWith(Parameterized.class)
public class UpdateAndGetSettingsExtAllYesTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Integer counter = MetrikaGoals.getCounterForLogin(client);

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long campaignID;
    private Map<SmartCampaignSettingsGetEnum, YesNoEnum> expectedSettings;
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public SmartCampaignSettingsEnum option;

    @Parameterized.Parameters(name = "option = {0}")
    public static Collection<Object[]> testData() {
        List<Object[]> data = new ArrayList<>();
        for (SmartCampaignSettingsEnum settingsEnum : SmartCampaignSettingsEnum.values()) {
            if (SMART_CAMPAIGN_DEPRECATED_SETTINGS.contains(settingsEnum)) {
                continue;
            }
            data.add(new Object[]{settingsEnum});
        }
        return data;
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        expectedSettings = new HashMap<>();
        for (SmartCampaignSettingsGetEnum settingsEnum : SmartCampaignSettingsGetEnum.values()) {
            if (SMART_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(settingsEnum)) {
                continue;
            }
            YesNoEnum value = settingsEnum.value().equals(option.value()) ? YesNoEnum.NO : YesNoEnum.YES;
            expectedSettings.put(settingsEnum, value);
        }

        ArrayList<SmartCampaignSettingMap> settings = new ArrayList<>();
        for (SmartCampaignSettingsEnum settingsEnum : SmartCampaignSettingsEnum.values()) {
            if (SMART_CAMPAIGN_DEPRECATED_SETTINGS.contains(settingsEnum)) {
                continue;
            }
            settings.add(new SmartCampaignSettingMap().withOption(settingsEnum).withValue(YesNoEnum.YES));
        }
        campaignID = api.userSteps.campExtSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withSmartCampaign(new SmartCampaignAddItemMap()
                                .defaultSmartCampaign()
                                .withCounterId(Long.valueOf(counter))
                                .withSettings(settings.toArray(new SmartCampaignSettingMap[]{}))
                        ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("950")
    public void checkUpdateSettingsTest() {
        api.userSteps.campExtSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignID)
                .withSmartCampaign(new SmartCampaignUpdateItemMap()
                        .withSettings(new SmartCampaignSettingMap()
                                .withOption(option)
                                .withValue(YesNoEnum.NO)))
        ));
        GetResponse getResponse = api.as(client).userSteps.campExtSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<SmartCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getSmartCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        Map<SmartCampaignSettingsGetEnum, YesNoEnum> settingsMap =
                StreamEx.of(settings)
                        .mapToEntry(SmartCampaignSettingGet::getOption, SmartCampaignSettingGet::getValue)
                        .filterKeys(x -> !SMART_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(x))
                        .toMap();
        assertThat("вернулся ожидаемый набор настроек", settingsMap,
                beanDiffer(expectedSettings));
    }
}
