package ru.yandex.autotests.direct.api.campext.update.textcampaign.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import com.yandex.direct.api.v5.campaignsext.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSettingGet;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaignsext.TextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import one.util.streamex.StreamEx;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.TEXT_CAMPAIGN_DEPRECATED_SETTINGS;
import static ru.yandex.autotests.direct.api.campext.CampaignsExtDeprecatedSettings.TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by buhter on 04.02.16.
 * https://st.yandex-team.ru/TESTIRT-8435
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-50402")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка поля Settings. Независимость изменений с NO на YES")
@RunWith(Parameterized.class)
public class UpdateAndGetSettingsExtAllNoTest {
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static final String client = CampaignsLogins.GET_SERV_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public TextCampaignSettingsEnum option;

    private Long campaignID;
    private Map<TextCampaignSettingsGetEnum, YesNoEnum> expectedSettings;

    @Parameterized.Parameters(name = "option = {0}")
    public static Collection testData() {
        List<Object[]> data = new ArrayList<Object[]>();
        for (TextCampaignSettingsEnum textCampaignSettingsEnum : TextCampaignSettingsEnum.values()) {
            if (TEXT_CAMPAIGN_DEPRECATED_SETTINGS.contains(textCampaignSettingsEnum)) {
                continue;
            }

            data.add(new Object[]{textCampaignSettingsEnum});
        }

        return data;
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        expectedSettings = new HashMap<>();
        for (TextCampaignSettingsGetEnum textCampaignSettingsGetEnum : TextCampaignSettingsGetEnum.values()) {
            if (TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(textCampaignSettingsGetEnum)) {
                continue;
            }

            YesNoEnum value = YesNoEnum.NO;
            if (textCampaignSettingsGetEnum.value().equals(option.value())
                    || textCampaignSettingsGetEnum == TextCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED) {
                value = YesNoEnum.YES;
            }
            expectedSettings.put(textCampaignSettingsGetEnum, value);
        }

        ArrayList<TextCampaignSettingMap> settings = new ArrayList<>();
        for (TextCampaignSettingsEnum textCampaignSettingsEnum : TextCampaignSettingsEnum.values()) {
            if (TEXT_CAMPAIGN_DEPRECATED_SETTINGS.contains(textCampaignSettingsEnum)) {
                continue;
            }

            settings.add(new TextCampaignSettingMap().withOption(textCampaignSettingsEnum).withValue(YesNoEnum.NO));
        }
        campaignID = api.userSteps.campExtSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .defaultTextCampaign()
                                .withSettings(settings.toArray(new TextCampaignSettingMap[settings.size()]))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1104")
    public void checkUpdateSettingsTest() {
        api.userSteps.campExtSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap()
                .withId(campaignID)
                .withTextCampaign(new TextCampaignUpdateItemMap()
                        .withSettings(new TextCampaignSettingMap()
                                .withOption(option)
                                .withValue(YesNoEnum.YES)))
        ));

        GetResponse getResponse = api.as(client).userSteps.campExtSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(campaignID))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));

        List<TextCampaignSettingGet> settings = getResponse.getCampaigns().get(0).getTextCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        Map<TextCampaignSettingsGetEnum, YesNoEnum> settingsMap =
                StreamEx.of(settings)
                        .mapToEntry(TextCampaignSettingGet::getOption, TextCampaignSettingGet::getValue)
                        .filterKeys(x -> !TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET.contains(x))
                        .toMap();
        assertThat("вернулся ожидаемый набор настроек", settingsMap,
                beanDiffer(expectedSettings));
    }
}
