package ru.yandex.autotests.directapi.changes.check;

import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@Description("Проверка доступности cpm_banner кампании в методе check.")
@Tag(TagDictionary.TRUNK)
public class CheckCpmBannerTest {

    private static final String ANOTHER_HREF = "http://google.ru";

    private static String timestamp;
    private static Long campaignId;
    private static Long adGroupId;
    private static Long bannerId;
    private static String client = ChangesLogins.CHANGES_CLIENT5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        Long creativeId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(client).getClientID()));
        bannerId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(adGroupId, creativeId);

        timestamp = api.userSteps.changesSteps().getTimestamp();

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(campaignId)
                                        .withName(RandomStringUtils.randomAlphabetic(10))
                        ),
                ExpectedResult.success());

        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withName(RandomStringUtils.randomAlphabetic(10))
                ),
                ExpectedResult.success()
        );

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(bannerId)
                                .withCpmBannerAdBuilderAd(new CpmBannerAdBuilderAdUpdateMap()
                                        .withHref(ANOTHER_HREF))),
                ExpectedResult.success(bannerId));
    }

    @Test
    public void tryCheckCpmBannerCampaign_ByCampaignId() {
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS)
        );
        assertThat("Получен campaignId в ответе",
                checkResponse.getModified().getCampaignIds(), hasSize(1));
    }

    @Test
    public void tryCheckCpmBannerCampaign_ByAdGroupId() {
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdGroupIds(adGroupId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_GROUP_IDS)
        );
        assertThat("Получен adGroupId в ответе",
                checkResponse.getModified().getAdGroupIds(), hasSize(1));
    }

    @Test
    public void tryCheckCpmBannerCampaign_ByAdId() {
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdIds(bannerId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_IDS)
        );
        assertThat("Получен bannerId в ответе",
                checkResponse.getModified().getAdIds(), hasSize(1));
    }
}
