package ru.yandex.autotests.directapi.changes.check;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.banners.BannerInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 27.04.15.
 * https://st.yandex-team.ru/TESTIRT-4916
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка работы метода с параметрами превышающими допустимый лимит.")
public class CheckLimitNegativeTest {
    private static LogSteps log = LogSteps.getLogger(CheckSmokeTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;
    private static Long bannerId;
    private static Long adGroupId;
    private static String timestamp;

    @Rule
    public Trashman trashman = new Trashman(api);
    private static int CAMPAIGN_ID_LIMIT = 3000;
    private static int ADGROUP_ID_LIMIT = 10000;
    private static int AD_ID_LIMIT = 50000;

    @BeforeClass
    public static void createData(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        adGroupId = api.userSteps.adGroupsSteps().adGroupsGet(new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withCampaignIds((long)campaignId)
                )
                .withFieldNames(
                        AdGroupFieldEnum.ID)).getAdGroups().get(0).getId();

        timestamp = api.userSteps.changesSteps().getTimestamp();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3424")
    public void tryCheckWithOverLimitCampaignIds(){
        Long[] campaignIDs = new Long[CAMPAIGN_ID_LIMIT + 1];
        Arrays.fill(campaignIDs, campaignId.longValue());
        api.userSteps.changesSteps().shouldGetErrorOnCheck(
                new CheckRequestMap()
                    .withTimestamp(timestamp)
                    .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS)
                    .withCampaignIds(campaignIDs),
                JavaOrPerlApi5Error
                        .java(new Api5Error(9300,
                                Api5ErrorDetailsJava.MAX_OBJECTS,
                                CAMPAIGN_ID_LIMIT))
                        .perl(new Api5Error(9300,
                                Api5ErrorDetails.AMOUNT_OF_ELEMENTS_IN_FIELD_MUST_NOT_EXCEED,
                                capitalize(CheckRequestMap.CAMPAIGN_IDS),
                                CAMPAIGN_ID_LIMIT))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3425")
    public void tryCheckWithOverLimitAdGroupIds(){
        Long[] adGroupIDs = new Long[ADGROUP_ID_LIMIT+1];
        Arrays.fill(adGroupIDs, adGroupId);
        api.userSteps.changesSteps().shouldGetErrorOnCheck(
                new CheckRequestMap()
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_GROUP_IDS)
                        .withAdGroupIds(adGroupIDs),
                JavaOrPerlApi5Error
                        .java(new Api5Error(9300,
                                Api5ErrorDetailsJava.MAX_OBJECTS,
                                ADGROUP_ID_LIMIT))
                        .perl(new Api5Error(9300,
                                Api5ErrorDetails.AMOUNT_OF_ELEMENTS_IN_FIELD_MUST_NOT_EXCEED,
                                capitalize(CheckRequestMap.ADGROUP_IDS),
                                ADGROUP_ID_LIMIT))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3426")
    public void tryCheckWithOverLimitAdIds(){
        Long[] adIDs = new Long[AD_ID_LIMIT+1];
        Arrays.fill(adIDs, bannerId.longValue());
        api.userSteps.changesSteps().shouldGetErrorOnCheck(
                new CheckRequestMap()
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_IDS)
                        .withAdIds(adIDs),
                JavaOrPerlApi5Error
                        .java(new Api5Error(9300,
                                Api5ErrorDetailsJava.MAX_OBJECTS,
                                AD_ID_LIMIT))
                        .perl(new Api5Error(9300,
                                Api5ErrorDetails.AMOUNT_OF_ELEMENTS_IN_FIELD_MUST_NOT_EXCEED,
                                capitalize(CheckRequestMap.AD_IDS),
                                AD_ID_LIMIT))
        );
    }

}
