package ru.yandex.autotests.directapi.changes.check;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 29.04.15.
 * https://st.yandex-team.ru/TESTIRT-4916
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка работы метода с максимльным количеством параметров.")
public class CheckLimitPositiveTest {
    private static LogSteps log = LogSteps.getLogger(CheckSmokeTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;
    private static Long bannerId;
    private static Long adGroupId;
    private static String timestamp;

    @Rule
    public Trashman trashman = new Trashman(api);
    private static int CAMPAIGN_ID_LIMIT = 3000;
    private static int ADGROUP_ID_LIMIT = 10000;
    private static int AD_ID_LIMIT = 50000;

    @BeforeClass
    public static void createData(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        adGroupId = api.userSteps.adGroupsSteps().adGroupsGet(new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withCampaignIds((long)campaignId)
                )
                .withFieldNames(
                        AdGroupFieldEnum.ID)).getAdGroups().get(0).getId();

        timestamp = api.userSteps.changesSteps().getTimestamp();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3427")
    public void tryCheckWithOverLimitCampaignIds(){
        Long[] campaignIDs = new Long[CAMPAIGN_ID_LIMIT];
        Arrays.fill(campaignIDs, campaignId.longValue());
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS)
                        .withCampaignIds(campaignIDs)
        );
        assertThat("не получены CampaignIDs в ответе",
                checkResponse.getModified().getCampaignIds().toArray(),
                equalTo(new Object[]{}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3428")
    public void tryCheckWithOverLimitAdGroupIds(){
        Long[] adGroupIDs = new Long[ADGROUP_ID_LIMIT];
        Arrays.fill(adGroupIDs, adGroupId);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_GROUP_IDS)
                        .withAdGroupIds(adGroupIDs)
        );
        assertThat("не получены AdGroupIds в ответе",
                checkResponse.getModified().getAdGroupIds().toArray(),
                equalTo(new Object[]{}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3429")
    public void tryCheckWithOverLimitAdIds(){
        Long[] adIDs = new Long[AD_ID_LIMIT];
        Arrays.fill(adIDs, bannerId.longValue());
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_IDS)
                        .withAdIds(adIDs)
        );
        assertThat("не получены AdIds в ответе",
                checkResponse.getModified().getAdIds().toArray(),
                equalTo(new Object[]{}));
    }

}
