package ru.yandex.autotests.directapi.changes.check;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Author ginger
 * https://st.yandex-team.ru/TESTIRT-9520
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class CheckNotSupportedCampaignTypeTest {
    private static String timestamp;
    private static Long campaignId;
    private static Long adGroupId;
    private static Long adId;
    private static String client = ChangesLogins.CHANGES_CLIENT5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameters(name = "тип кампании - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.GEO},
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.WALLET}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        timestamp = api.userSteps.changesSteps().getTimestamp();

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(campaignId)
                                        .withName(RandomStringUtils.randomAlphabetic(10))
                        ),
                ExpectedResult.success());

        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withName(RandomStringUtils.randomAlphabetic(10))
                ),
                ExpectedResult.success()
        );

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .withTitle(RandomStringUtils.randomAlphabetic(10)))),
                ExpectedResult.success(adId));
    }

    @Before
    public void updateType() {
        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
    }

    @Test
    public void tryCheckNotSupportedCampaignTypeByCampaignId() {
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds((long) campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS)
        );
        assertThat("не получены CampaignIDs в ответе",
                checkResponse.getModified().getCampaignIds(), hasSize(0));
    }

    @Test
    public void tryCheckNotSupportedCampaignTypeByAdGroupId() {
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdGroupIds((long) adGroupId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_GROUP_IDS)
        );
        assertThat("не получены AdGroupIds в ответе",
                checkResponse.getModified().getAdGroupIds(), hasSize(0));
    }

    @Test
    public void tryCheckNotSupportedCampaignTypeByAdId() {
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdIds((long) adId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.AD_IDS)
        );
        assertThat("не получены AdId в ответе",
                checkResponse.getModified().getAdIds(), hasSize(0));
    }
}
