package ru.yandex.autotests.directapi.changes.check;

import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import com.yandex.direct.api.v5.changes.CheckResponseIds;
import com.yandex.direct.api.v5.changes.CheckResponseModified;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckResponseIdsMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckResponseMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckResponseModifiedMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 27.04.15.
 * https://st.yandex-team.ru/TESTIRT-4916
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка корректных входных параметров.")
@Tag(TagDictionary.TRUNK)
public class CheckPositiveTest {
    private static LogSteps log = LogSteps.getLogger(CheckSmokeTest.class);

    private static String holodilnikLogin = ChangesLogins.HOLODILNIKRU;
    private static String clientLogin = ChangesLogins.CHANGES_CLIENT;
    private static Long holodilnikCampaignId = 263L;
    private static Long campaignId;
    private static Long bannerId;
    private static Long adGroupId;
    private static String timestamp;
    private String oldTimestamp = "2010-04-27T16:59:13Z";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void createData(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, clientLogin);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId, clientLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3446")
    public void changeOnlyAdField(){
        timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        api.userSteps.adsSteps().adsUpdate(
                new ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withId(bannerId)
                        .withTextAd(new TextAdUpdateMap().withText("ginger " + RandomStringUtils.randomAlphabetic(3)))
                ),clientLogin);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS, CheckFieldEnum.AD_IDS, CheckFieldEnum.AD_GROUP_IDS),
                clientLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse =
                new CheckResponseMap()
                    .withModified(
                            (CheckResponseModified)(
                                    new CheckResponseModifiedMap()
                                            .withAdIds(bannerId)
                                            .getBean()));
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3447")
    public void changeOnlyCampaignField(){
        timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        api.userSteps.campaignSteps().campaignsUpdate(new ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withName("ginger " + RandomStringUtils.randomAlphabetic(3))),clientLogin);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdGroupIds(adGroupId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS, CheckFieldEnum.AD_IDS, CheckFieldEnum.AD_GROUP_IDS),
                clientLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse =
                new CheckResponseMap()
                        .withModified(
                                (CheckResponseModified)(
                                        new CheckResponseModifiedMap()
                                                .withCampaignIds(campaignId)
                                                .getBean()));
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3448")
    public void changeOnlyAdGroupField(){
        timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName("ginger " + RandomStringUtils.randomAlphabetic(3))
                ), clientLogin);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdIds(bannerId.longValue())
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS, CheckFieldEnum.AD_IDS, CheckFieldEnum.AD_GROUP_IDS),
                clientLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse =
                new CheckResponseMap()
                        .withModified(
                                (CheckResponseModified)(
                                        new CheckResponseModifiedMap()
                                                .withAdGroupIds(adGroupId)
                                                .getBean()));
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3449")
    public void changeCampaignAndAdGroupAndAdField(){
        timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName("ginger " + RandomStringUtils.randomAlphabetic(3))
                ), clientLogin);
        api.userSteps.campaignSteps().campaignsUpdate(
                new ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap()
                .withCampaigns(new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withName("ginger " + RandomStringUtils.randomAlphabetic(3))),clientLogin);
        api.userSteps.adsSteps().adsUpdate(
                new ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withId(bannerId)
                                .withTextAd(new TextAdUpdateMap().withText("ginger " + RandomStringUtils.randomAlphabetic(3)))
                ), clientLogin);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdIds(bannerId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS, CheckFieldEnum.AD_IDS, CheckFieldEnum.AD_GROUP_IDS),
                clientLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse =
                new CheckResponseMap()
                        .withModified(
                                (CheckResponseModified)(
                                        new CheckResponseModifiedMap()
                                                .withCampaignIds(campaignId)
                                                .withAdGroupIds(adGroupId)
                                                .withAdIds(bannerId)
                                                .getBean()));
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3450")
    public void checkNonExistenceCampaign(){
        timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(1l)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS, CheckFieldEnum.AD_IDS, CheckFieldEnum.AD_GROUP_IDS),
                clientLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse
                = new CheckResponseMap()
                    .withNotFound((CheckResponseIds)(new CheckResponseIdsMap().withCampaignIds(1l).getBean()));
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3451")
    public void checkNonExistenceAdGroup(){
        timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdGroupIds(1L)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS, CheckFieldEnum.AD_IDS, CheckFieldEnum.AD_GROUP_IDS),
                clientLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse
                = new CheckResponseMap()
                .withNotFound((CheckResponseIds)(new CheckResponseIdsMap().withAdGroupIds(1l).getBean()));
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3452")
    public void checkNonExistenceAd(){
        timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withAdIds(1L)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS, CheckFieldEnum.AD_IDS, CheckFieldEnum.AD_GROUP_IDS),
                clientLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse
                = new CheckResponseMap()
                .withNotFound((CheckResponseIds)(new CheckResponseIdsMap().withAdIds(1l).getBean()));
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3453")
    public void checkWithOnlyCampaignIdsInFieldsNames(){
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(holodilnikCampaignId)
                        .withTimestamp(oldTimestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS),
                holodilnikLogin
        );
        assertThat("не получен CampaignIDs в ответе",
                checkResponse.getModified().getCampaignIds().toArray(),
                equalTo(new Object[]{holodilnikCampaignId}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3454")
    public void checkWithOnlyCampaignsStatInFieldsNames(){
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(holodilnikCampaignId)
                        .withTimestamp(oldTimestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGNS_STAT),
                holodilnikLogin
        );
        assertThat("не получен CampaignsStat в ответе",
                checkResponse.getModified().getCampaignsStat().toArray(),
                notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3455")
    public void checkWithOnlyAdGroupIdsInFieldsNames(){
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(holodilnikCampaignId)
                        .withTimestamp(oldTimestamp)
                        .withFieldNames(CheckFieldEnum.AD_GROUP_IDS),
                holodilnikLogin
        );
        assertThat("не получен AdGroupIds в ответе",
                checkResponse.getModified().getAdGroupIds().toArray(),
                notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3443")
    public void checkWithOnlyAdIdsInFieldsNames(){
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(holodilnikCampaignId)
                        .withTimestamp(oldTimestamp)
                        .withFieldNames(CheckFieldEnum.AD_IDS),
                holodilnikLogin
        );
        assertThat("не получены AdIds в ответе",
                checkResponse.getModified().getAdIds().toArray(),
                notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3444")
    public void checkWithAllValueInFieldsNames(){
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(holodilnikCampaignId)
                        .withTimestamp(oldTimestamp)
                        .withFieldNames(
                                CheckFieldEnum.AD_IDS,
                                CheckFieldEnum.AD_GROUP_IDS,
                                CheckFieldEnum.CAMPAIGN_IDS,
                                CheckFieldEnum.CAMPAIGNS_STAT),
                holodilnikLogin
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP, CheckResponseMap.MODIFIED).useMatcher(notNullValue());
        CheckResponse expectedResponse = new CheckResponse();
        expectedResponse.setNotFound(null);
        expectedResponse.setUnprocessed(null);
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse)
                .withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3445")
    public void checkAfterDeleteCampaign(){
        String timestamp = api.userSteps.changesSteps().getTimestamp(clientLogin);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(clientLogin);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId,clientLogin);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, clientLogin);
        api.userSteps.campaignSteps().campaignsDelete(clientLogin, campaignId);
        CheckResponse checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS),
                clientLogin
        );
        assertThat("не получены CampaignIDs в ответе",
                checkResponse.getNotFound().getCampaignIds().toArray(),
                equalTo(new Object[]{campaignId}));
    }
}
