package ru.yandex.autotests.directapi.changes.check;

import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckResponseMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 29.04.15.
 * https://st.yandex-team.ru/TESTIRT-4916
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка доступа ролей к методу.")
@Tag(TagDictionary.TRUNK)
public class CheckRolesAccessNegativeTest {
    public String subclient = Logins.SUBCLIENT_CAMPAIGNS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.AGENCY_1_CAMPAIGNS);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private CheckResponse checkResponse;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3456")
    public void callChangesCheckCampaigns(){
        String timestamp = api.userSteps.changesSteps().getTimestamp(subclient);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, subclient);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, subclient);
        checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds((long) campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS),
                Logins.SUBCLIENT_CAMPAIGNS

        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckResponseMap.TIMESTAMP).useMatcher(notNullValue());
        CheckResponseMap expectedResponse = new CheckResponseMap()
                .withNotFound(null).withModified(null).withUnprocessed(null);
        assertThat("вернулись корректные значения", checkResponse, beanEquivalent(expectedResponse.getBean())
                .withVariation(variation));
    }
}
