package ru.yandex.autotests.directapi.changes.check;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 27.04.15.
 * https://st.yandex-team.ru/TESTIRT-4916
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка доступа ролей к методу.")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckRolesAccessPositiveTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuth;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameters(name = "loginForAuth = {0}, login = {1}")
    public static Collection testLogins() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, ChangesLogins.SERVICED_CLIENT_IN_2_SHARD},
                {Logins.PLACER, ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPPORT,ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPER_LOGIN,ChangesLogins.CHANGES_CLIENT},
                {Logins.MEDIA,ChangesLogins.CHANGES_CLIENT},
                {Logins.SUPER_READER,ChangesLogins.CHANGES_CLIENT},
                {ChangesLogins.CHANGES_CLIENT,ChangesLogins.CHANGES_CLIENT},
                {ChangesLogins.AGENCY_CAMPAIGNS,ChangesLogins.SUB_CLIENT_WITH_EDIT_RIGHTS}
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3457")
    public void callChangesCheckCampaigns(){
        //DIRECT-41537
        Long campaignId = api.as(login).userSteps.campaignSteps().addDefaultTextCampaign(login);
        String timestamp = api.as(loginForAuth).userSteps.changesSteps().getTimestamp(login);
        CheckResponse checkResponse = api.as(loginForAuth).userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds((long) campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS),
                login
        );
        assertThat("не получены CampaignIDs в ответе",
                checkResponse.getModified().getCampaignIds().toArray(),
                equalTo(new Object[]{}));
    }
}
