package ru.yandex.autotests.directapi.changes.check;

import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.core.IsEqual.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 25.03.15.
 * https://st.yandex-team.ru/TESTIRT-4916
 */
@Features(ChangesFeatures.SMOKE)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
public class CheckSmokeTest {
    private static LogSteps log = LogSteps.getLogger(CheckSmokeTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private CheckResponse checkResponse;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3458")
    public void callChangesCheck(){
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds((long) campaignId)
                        .withTimestamp(timestamp)
                        .withFieldNames(CheckFieldEnum.CAMPAIGN_IDS)
        );
        assertThat("не получены CampaignIDs в ответе",
                checkResponse.getModified().getCampaignIds().toArray(),
                equalTo(new Object[]{}));
    }

}
