package ru.yandex.autotests.directapi.changes.check;

import java.util.List;

import ch.lambdaj.function.convert.PropertyExtractor;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.changes.CheckFieldEnum;
import com.yandex.direct.api.v5.changes.CheckResponse;
import org.json.simple.parser.ParseException;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.convert;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 26.04.15.
 * https://st.yandex-team.ru/TESTIRT-4916
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка корректности ответа (поле Unprocessed) при превышении лимита ответа.")
public class CheckUnprocessedTest {
    private static LogSteps log = LogSteps.getLogger(CheckSmokeTest.class);

    /* поискат подходящих клиентов можно по ссылке
     https://test-direct.yandex.ru/registered/main.pSR5ZD6zNoL9Yfm5.pl?cmd=internalReports&sort=&reverse=&report_id=test_data_generator_client&ir_param_camps_count=950
     */
    private static final String MORE_THAN_300_CAMPAIGNS_LOGIN = "engency-remontexpress";
    private static final String OLD_TIME_STAMP = "2010-04-27T16:59:13Z";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private CheckResponse checkResponse;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3462")
    public void callChangesCheck() throws ParseException {
        GetResponse campaigns = api.as(Logins.SUPER_LOGIN, MORE_THAN_300_CAMPAIGNS_LOGIN).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()).withFieldNames(CampaignFieldEnum.ID));


        List<Long> ids = convert(campaigns.getCampaigns(), new PropertyExtractor(CampaignGetItemMap.ID));

        final Long[] campaignIds = ids.stream().map(i -> new Long(i)).limit(300).toArray(Long[]::new);

        checkResponse = api.userSteps.changesSteps().changesCheck(
                new CheckRequestMap()
                        .withCampaignIds(campaignIds)
                        .withTimestamp(OLD_TIME_STAMP)
                        .withFieldNames(
                                CheckFieldEnum.CAMPAIGN_IDS,
                                CheckFieldEnum.AD_IDS,
                                CheckFieldEnum.AD_GROUP_IDS,
                                CheckFieldEnum.CAMPAIGNS_STAT
                        ),
                MORE_THAN_300_CAMPAIGNS_LOGIN
        );
        assertThat("не получены Unprocessed в ответе",
                checkResponse.getUnprocessed(),notNullValue());


    }
}
