package ru.yandex.autotests.directapi.changes.check;

import com.yandex.direct.api.v5.changes.CheckDictionariesRequest;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckDictionariesRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Created by ginger on 25.06.15.
 * https://st.yandex-team.ru/TESTIRT-6065
 */

@Aqua.Test
@Features(ChangesFeatures.CHECK)
@Issue("https://st.yandex-team.ru/DIRECT-64794")
@Description("Проверка невалидного заголовка.")
public class MalformedHttpHeaderTest {
    private static LogSteps log = LogSteps.getLogger(MalformedJsonTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private static String invalidSymbol =  "\"";

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-43146")
    public void tryCallCheckWithInvalidSymbolInHeaders() {
        CheckDictionariesRequest params = (CheckDictionariesRequest) new CheckDictionariesRequestMap()
                .getBean();
        api.userSteps.changesSteps().shouldGetJSONErrorOnCheckDictionaries(
                params,
                login + invalidSymbol,
                new Api5Error(
                        8800,
                        Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN
                ));
    }
}
