package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.model.common.RegionIDValues;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 04.04.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.BUG)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка наличия CHILDREN изменений в кампании.")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class ChangesChildrenNotReadyTest {

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;
    private static Long adGroupId;

    @Rule
    public Trashman trashman = new Trashman(api);
    private Long bannerId;
    private long keywordId;

    @BeforeClass
    public static void createCampaign(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
    }

    @Before
    public void setUp(){
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3465")
    public void checkCampaignsAfterUpdatingBanner(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().adsUpdate(
                new ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withId(bannerId)
                                .withTextAd(new TextAdUpdateMap().withText("ginger " + RandomStringUtils.randomAlphabetic(3)))
                ));
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3467")
    public void checkCampaignsAfterUpdatingAdGroupName(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName("ginger " + RandomStringUtils.randomAlphabetic(3))),
                login);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3468")
    public void checkCampaignsAfterUpdatingHref(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap().withAds(
                        new AdUpdateItemMap().withId(bannerId)
                                .withTextAd(new TextAdUpdateMap().withHref("http://somedomain"))
                ),
                ExpectedResult.success());
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3469")
    public void checkCampaignsAfterUpdatingGeo(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withRegionIds(Long.valueOf(RegionIDValues.KIEV_REGION_ID))),
                login);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Title("Bug DIRECT-40772")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3471")
    public void checkCampaignsAfterUpdatingPointOnMap(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Title("Bug DIRECT-40772")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3472")
    public void checkCampaignsAfterUpdatingPhrasePrice(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.bidsSteps().bidsSet(new SetRequestMap().withBids(
                new BidSetItemMap().withKeywordId(keywordId).withBid(9000000L)
        ));
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Title("Bug DIRECT-40772")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3473")
    public void checkCampaignsAfterUpdatingUserParams(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.keywordsSteps().keywordsUpdate(
                new KeywordUpdateMap().withId(keywordId).withUserParam1("new param"));
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3474")
    public void checkCampaignsAfterUpdatingMinusKeywords(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(adGroupId)
                                .withNegativeKeywords("ginger" + RandomStringUtils.randomAlphabetic(3)))
        );
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }


    @Title("Bug DIRECT-40772")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3476")
    public void checkCampaignsAfterUpdatingAdGroupMobileBidAdjustment(){
        //DIRECT-40772
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.bidModifiersSteps().addBidModifierMobileToCampaign(campaignId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }
}

