package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywords.KeywordUpdateMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 31.03.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка наличия CHILDREN изменений в кампании.")
@Tag(TagDictionary.TRUNK)
public class ChangesInChildrenTest {

    private static String login = ChangesLogins.CHANGES_CLIENT4;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;
    private static Long bannerId;
    private static Long keywordId;
    private static String imageHashes;
    private static Long adGroupId;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void createData(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        bannerId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        imageHashes = api.userSteps.imagesSteps().configLoginImages(login, ImageType.REGULAR, 3)[0];

    }

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3477")
    public void checkCampaignsAfterCreatingBanner(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3478")
    public void checkCampaignsAfterCreatingGroup(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3479")
    public void checkCampaignsAfterUpdatingGroup(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "ging")
        ));
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3480")
    public void checkCampaignsAfterAddImage() {
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.imagesSteps().setAdImageAssociation(bannerId, imageHashes);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3481")
    public void checkCampaignsAfterUpdatingKeyword(){
        //DIRECT-40662
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.keywordsSteps().keywordsUpdate(
                new KeywordUpdateMap().withId(keywordId).withKeyword("new key")
        );
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3482")
    public void checkCampaignsAfterAddingRetargeting() {
        Long retargetingListId = api.userSteps.retargetingListsSteps().addDefaultRetargetingLists(login);
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.audienceTargetsSteps().addWithRetargetingList(adGroupId, retargetingListId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3483")
    public void checkCampaignsAfterAddingRetargetingCondition() {
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.retargetingSteps().addRandomConditionsForUserBanner(login, bannerId, 2);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));

    }

    //ToDo: StopBanner, ArchiveBanner....  , SetAutoPrice  , визитка   к задаче LastChange (уточнить)

}
