package ru.yandex.autotests.directapi.changes.checkcampaigns;

import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@Description("Проверка доступности cpm_banner кампании в методе checkCampaigns.")
@Tag(TagDictionary.TRUNK)
public class ChangesInCpmBannerTest {

    private String timestamp;
    private static String client = ChangesLogins.CHANGES_CLIENT6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    public void tryCheckCpmBannerCampaign() {
        CheckCampaignsResponse checkCampaignsResponse = api.userSteps.changesSteps().changesCheckCampaigns(
                new CheckCampaignsRequestMap()
                        .withTimestamp(timestamp));

        assertThat("Получена кампания в ответе", checkCampaignsResponse.getCampaigns(), hasSize(1));
    }
}
