package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 04.04.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.BUG)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка наличия SELF изменений в кампании.")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class ChangesInSelfNotReadyTest {

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    public static Long campaignId;

    @BeforeClass
    public static void createData(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Title("Bug DIRECT-40604")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3484")
    public void checkCampaignsAfterStopCampaign(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.SELF))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Title("Bug DIRECT-40606")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3485")
    public void checkCampaignsAfterChangingSum(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.campaignFakeSteps().setCampaignSum(campaignId, 40f);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.SELF))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3486")
    public void checkCampaignsAfterChangingMinusKeywords(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap().withId(campaignId)
                        .withNegativeKeywords("ginger"+ RandomStringUtils.randomAlphabetic(3))
                )
        );
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.SELF))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }


}
