package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 31.03.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка наличия SELF изменений в кампании.")
@Tag(TagDictionary.TRUNK)
public class ChangesInSelfTest {

    private static String login = ChangesLogins.CHANGES_CLIENT3;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    public static Long campaignId;
    private String timestamp;

    @Before
    @Step("создание кампании")
    public void createDate() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                new TextCampaignNetworkStrategyAddMap().defaultAverageCpc(Currency.RUB),
                login
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        timestamp = api.userSteps.changesSteps().getTimestamp();

        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3487")
    public void checkCampaignsAfterChangingStrategy(){
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap().withId(campaignId).withTextCampaign(
                                new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                .withSearch(new TextCampaignSearchStrategyMap().defaultServingOff())
                                .withNetwork(new TextCampaignNetworkStrategyMap().defaultAverageCpc(Currency.RUB))))
                        )
                );
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.SELF))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3488")
    public void checkCampaignsAfterChangingAndDelete(){
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap().withId(campaignId)
                        .withName("ginger" + RandomStringUtils.randomAlphabetic(3))
                )
        );
        api.userSteps.campaignSteps().campaignsDelete(campaignId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        assertThat("вернулись корректные значения", actualCampaignsResponse,
                beanEquivalent(expectedCampaignResponse));
    }

}
