package ru.yandex.autotests.directapi.changes.checkcampaigns;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 31.03.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка наличия STAT изменений (корректировка статистики) в кампании.")
@Tag(TagDictionary.TRUNK)
public class ChangesInStatTest {
    private static LogSteps log = LogSteps.getLogger(CheckCampaignsSmokeTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;
    private Long holodilnikCampaignId = 1580l;
    private String timestampForStat = "2014-01-01T11:12:59Z";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3489")
    public void checkCampaignsAfterClicksAndShows(){
        CheckCampaignsResponse actualCampaignsResponse =
                api.as(Logins.SUPER_LOGIN,ChangesLogins.HOLODILNIKRU).userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestampForStat)
                );
        CampaignChangesItemMap expectedCampaignItems = new CampaignChangesItemMap()
                        .withCampaignId(holodilnikCampaignId)
                        .withChangesIn(
                                CampaignChangesInEnum.SELF,
                                CampaignChangesInEnum.CHILDREN,
                                CampaignChangesInEnum.STAT);
        assertThat("вернулись корректные значения",
                actualCampaignsResponse.getCampaigns(),
                hasItem(beanDiffer((CampaignChangesItem) expectedCampaignItems.getBean())));
    }
}
