package ru.yandex.autotests.directapi.changes.checkcampaigns;

import org.joda.time.DateTime;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 31.03.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Проверка некорректных входных данных.")
@Tag(TagDictionary.TRUNK)
public class CheckCampaignsNegativeTest {
    private static LogSteps log = LogSteps.getLogger(CheckCampaignsSmokeTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static String timestamp;

    @Rule
    public Trashman trashman = new Trashman(api);
    private String invalidFieldName = "gingerField";
    private String invalidFieldValue = "gingerValue";
    private String paramsString = "params";
    private String anotherISOFormat = "2015-05-29T13:10:46";

    @BeforeClass
    public static void getTimestamp(){
        timestamp = api.userSteps.changesSteps().getTimestamp();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3490")
    public void tryCheckCampaignsWithTimestampEmptyString(){
        api.userSteps.changesSteps().shouldGetErrorOnCheckCampaigns(
                new CheckCampaignsRequestMap()
                        .withTimestamp(""),
                JavaOrPerlApi5Error
                        .java(new Api5Error(4000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(4000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3491")
    public void trySoapCheckCampaignsWithoutTimestamp(){
        api.protocol(ProtocolType.SOAP).userSteps.changesSteps().shouldGetErrorOnCheckCampaigns(
                new CheckCampaignsRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        "CheckCampaignsRequest",
                        capitalize(CheckCampaignsRequestMap.TIMESTAMP))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3492")
    public void tryJsonCheckCampaignsWithoutTimestamp(){
        api.protocol(ProtocolType.JSON).userSteps.changesSteps().shouldGetErrorOnCheckCampaigns(
                new CheckCampaignsRequestMap(),
                JavaOrPerlApi5Error
                        .java(new Api5Error(8000,
                                Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(8000,
                                Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                                paramsString,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3493")
    public void tryCheckCampaignsWithAnotherDateFormat(){
        api.userSteps.changesSteps().shouldGetErrorOnCheckCampaigns(
                new CheckCampaignsRequestMap()
                        .withTimestamp(DateTime.now().toDate().toString()),
                JavaOrPerlApi5Error
                        .java(new Api5Error(4000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(4000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3494")
    public void tryCallCheckCampaignsWithAnotherIsoFormat(){
        //another ISO Format
        //https://st.yandex-team.ru/DIRECT-35821
        api.userSteps.changesSteps().shouldGetErrorOnCheckCampaigns(
                new CheckCampaignsRequestMap().withTimestamp(anotherISOFormat),
                JavaOrPerlApi5Error
                        .java(new Api5Error(4000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(4000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
        );
    }

 //------------------------------------------------ invalid JSON ------------------------------------------------------

    @Test
     @ru.yandex.qatools.allure.annotations.TestCaseId("3495")
     public void tryCheckCampaignsWithArrayTimestamp(){
        JSONObject params = new JSONObject();
        params.put(capitalize(CheckCampaignsRequestMap.TIMESTAMP),new Object[]{timestamp});
        api.userSteps.changesSteps().shouldGetJSONErrorOnCheckCampaigns(
                params,login,new Api5Error(8000,
                Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                capitalize(CheckCampaignsRequestMap.TIMESTAMP))
        );
     }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3496")
    public void tryCheckCampaignsWithIntegerTimestamp(){
        JSONObject params = new JSONObject();
        params.put(capitalize(CheckCampaignsRequestMap.TIMESTAMP), 666);
        api.userSteps.changesSteps().shouldGetJSONErrorOnCheckCampaigns(
                params, login,
                JavaOrPerlApi5Error
                        .java(new Api5Error(4000,
                                Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
                        .perl(new Api5Error(4000,
                                Api5ErrorDetails.FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
                                capitalize(CheckCampaignsRequestMap.TIMESTAMP)))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3497")
    public void tryCheckCampaignsWithUnknownField(){
        JSONObject params = new JSONObject();
        params.put(capitalize(CheckCampaignsRequestMap.TIMESTAMP), timestamp);
        params.put(capitalize(invalidFieldName), invalidFieldValue);
        api.userSteps.changesSteps().shouldGetJSONErrorOnCheckCampaigns(
                params, login,
                JavaOrPerlApi5Error
                        .java(new Api5Error(8000,
                                Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                                capitalize(invalidFieldName)))
                        .perl(new Api5Error(8000,
                                Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                                paramsString,
                                capitalize(invalidFieldName)))
        );
    }

}
