package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 10.07.16.
 * https://st.yandex-team.ru/TESTIRT-9520
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@RunWith(Parameterized.class)
public class CheckCampaignsNotSupportedCampaignTypeTest {
    private String timestamp;
    private static Long campaignId;
    private static String client = ChangesLogins.CHANGES_CLIENT6;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignsType campaignsType;

    @Parameterized.Parameters(name = "тип кампании - {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignsType.GEO},
                {CampaignsType.MCB},
                {CampaignsType.MCBANNER},
                {CampaignsType.WALLET}
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка тестовых данных")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.campaignFakeSteps().setType(campaignId, campaignsType);
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    public void tryCheckCampaignNotSupportedType() {
        CheckCampaignsResponse checkCampaignsResponse = api.userSteps.changesSteps().changesCheckCampaigns(
                new CheckCampaignsRequestMap()
                        .withTimestamp(timestamp)
        );
        assertThat("не получены Campaigns в ответе",
                checkCampaignsResponse.getCampaigns(), hasSize(0));
    }
}
