package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignInfo;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 04.04.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.BUG)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Общие позитивные проверки метода.")
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
public class CheckCampaignsPositiveNotReadyTest {

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static CampaignInfo campaignInfo;
    private static Long campaignId;
    private static String timestampBeforeEditChildren;
    private static String timestampAfterEditChildren;
    private String earlyTimestamp = "0010-01-01T11:12:59Z";
    private String lateTimestamp = "3010-01-01T11:12:59Z";

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        timestampBeforeEditChildren = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Title("DIRECT-40601")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3499")
    public void checkCampaignsWithTimestampBeforeEditChildren(){
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestampBeforeEditChildren)
                );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckCampaignsRequestMap.TIMESTAMP).useMatcher(notNullValue());
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse,beanEquivalent(expectedCampaignResponse)
                .withVariation(variation));
    }

    @Title("DIRECT-40601")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3498")
    public void checkCampaignsAfterUpdateWithoutChanging(){
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.campaignSteps().campaignsUpdate(
                new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap().withId(campaignId)
                ));
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestamp)
                );
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap())
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse, beanEquivalent(expectedCampaignResponse));
    }
}
