package ru.yandex.autotests.directapi.changes.checkcampaigns;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 31.03.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Aqua.Test
@Features(ChangesFeatures.CHECK_CAMPAIGNS)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
@Description("Общие позитивные проверки метода.")
@Tag(TagDictionary.TRUNK)
public class CheckCampaignsPositiveTest {

    private static String login = ChangesLogins.CHANGES_CLIENT2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;
    private static String timestampAfterEditChildren;
    private static String timestampBeforeEditChildren;
    private String earlyTimestamp = "0010-01-01T11:12:59Z";
    private String lateTimestamp = "3010-01-01T11:12:59Z";

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        timestampBeforeEditChildren = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3500")
    public void checkCampaignsWithVeryEarlyDate(){
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(earlyTimestamp)
                );
        CampaignChangesItemMap expectedCampaignItems = new CampaignChangesItemMap()
                .withCampaignId((long)campaignId)
                .withChangesIn(
                        CampaignChangesInEnum.SELF,
                        CampaignChangesInEnum.CHILDREN);
        assertThat("вернулись корректные значения",
                actualCampaignsResponse.getCampaigns(),
                hasItem(beanDiffer((CampaignChangesItem) expectedCampaignItems.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3501")
    public void checkCampaignsWithVeryLateDate(){
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(lateTimestamp)
                );
        assertThat("вернулись корректные значения",
                actualCampaignsResponse.getCampaigns().toArray(),
                equalTo(new Object[]{}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3502")
    public void checkCampaignsWithTimestampAfterEditChildren(){
        timestampAfterEditChildren = api.userSteps.changesSteps().getTimestamp();
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                        new CheckCampaignsRequestMap()
                                .withTimestamp(timestampAfterEditChildren)
                );
        assertThat("вернулись корректные значения",actualCampaignsResponse.getCampaigns().toArray(), equalTo(new Object[]{}));
    }
}
