package ru.yandex.autotests.directapi.changes.checkcampaigns;

import java.util.Arrays;

import com.yandex.direct.api.v5.changes.CampaignChangesInEnum;
import com.yandex.direct.api.v5.changes.CampaignChangesItem;
import com.yandex.direct.api.v5.changes.CheckCampaignsResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.changes.ChangesFeatures;
import ru.yandex.autotests.directapi.changes.ChangesLogins;
import ru.yandex.autotests.directapi.model.api5.changes.CampaignChangesItemMap;
import ru.yandex.autotests.directapi.model.api5.changes.CheckCampaignsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 25.03.15.
 * https://st.yandex-team.ru/TESTIRT-4917
 */
@Features(ChangesFeatures.SMOKE)
@Issue("https://st.yandex-team.ru/DIRECT-35862")
public class CheckCampaignsSmokeTest {
    private static LogSteps log = LogSteps.getLogger(CheckCampaignsSmokeTest.class);

    private static String login = ChangesLogins.CHANGES_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @Before
    public void setUp() {
        api.userSteps.changesSteps().setUseCampAggregatedLastChange(false);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3503")
    public void callChangesCheckCampaigns(){
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        CheckCampaignsResponse actualCampaignsResponse =
                api.userSteps.changesSteps().changesCheckCampaigns(
                new CheckCampaignsRequestMap()
                        .withTimestamp(timestamp)
        );
        MatchVariation variation = new DefaultMatchVariation()
                .forFields(CheckCampaignsRequestMap.TIMESTAMP).useMatcher(notNullValue());
        CheckCampaignsResponse expectedCampaignResponse = new CheckCampaignsResponse();
        expectedCampaignResponse.setCampaigns(Arrays.asList((CampaignChangesItem)
                (new CampaignChangesItemMap()
                        .withCampaignId((long) campaignId)
                        .withChangesIn(CampaignChangesInEnum.CHILDREN))
                        .getBean()));
        assertThat("вернулись корректные значения",actualCampaignsResponse,beanEquivalent(expectedCampaignResponse)
                .withVariation(variation));
    }
}
